/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.client;

import com.hazelcast.client.KeyBasedClientRequest;
import com.hazelcast.client.SecureRequest;
import com.hazelcast.map.EntryProcessor;
import com.hazelcast.map.MapPortableHook;
import com.hazelcast.map.operation.EntryOperation;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.nio.serialization.Portable;
import com.hazelcast.nio.serialization.PortableReader;
import com.hazelcast.nio.serialization.PortableWriter;
import com.hazelcast.security.permission.MapPermission;
import com.hazelcast.spi.Operation;
import java.io.IOException;
import java.security.Permission;

public class MapExecuteOnKeyRequest
extends KeyBasedClientRequest
implements Portable,
SecureRequest {
    private String name;
    private Data key;
    private EntryProcessor processor;
    private boolean submitToKey;

    public MapExecuteOnKeyRequest() {
    }

    public MapExecuteOnKeyRequest(String name, EntryProcessor processor, Data key) {
        this.name = name;
        this.processor = processor;
        this.key = key;
    }

    @Override
    protected Object getKey() {
        return this.key;
    }

    @Override
    protected Operation prepareOperation() {
        return new EntryOperation(this.name, this.key, this.processor);
    }

    @Override
    public String getServiceName() {
        return "hz:impl:mapService";
    }

    @Override
    public int getFactoryId() {
        return MapPortableHook.F_ID;
    }

    @Override
    public int getClassId() {
        return 38;
    }

    public void setAsSubmitToKey() {
        this.submitToKey = true;
    }

    @Override
    public void write(PortableWriter writer) throws IOException {
        writer.writeUTF("n", this.name);
        writer.writeBoolean("s", this.submitToKey);
        ObjectDataOutput out = writer.getRawDataOutput();
        this.key.writeData(out);
        out.writeObject(this.processor);
    }

    @Override
    public void read(PortableReader reader) throws IOException {
        this.name = reader.readUTF("n");
        this.submitToKey = reader.readBoolean("s");
        ObjectDataInput in = reader.getRawDataInput();
        this.key = new Data();
        this.key.readData(in);
        this.processor = (EntryProcessor)in.readObject();
    }

    @Override
    public Permission getRequiredPermission() {
        return new MapPermission(this.name, "put", "remove");
    }

    @Override
    public String getMethodName() {
        if (this.submitToKey) {
            return "submitToKey";
        }
        return "executeOnKey";
    }

    @Override
    public Object[] getParameters() {
        return new Object[]{this.key, this.processor};
    }
}

