/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.operation;

import com.hazelcast.map.RecordStore;
import com.hazelcast.map.operation.AbstractMapOperation;
import com.hazelcast.map.operation.ClearBackupOperation;
import com.hazelcast.spi.BackupAwareOperation;
import com.hazelcast.spi.Operation;
import com.hazelcast.spi.PartitionAwareOperation;

public class ClearOperation
extends AbstractMapOperation
implements BackupAwareOperation,
PartitionAwareOperation {
    boolean shouldBackup = true;
    private int numberOfClearedEntries;

    public ClearOperation() {
    }

    public ClearOperation(String name) {
        super(name);
    }

    @Override
    public void run() {
        this.mapService.clearNearCache(this.name);
        RecordStore recordStore = this.mapService.getExistingRecordStore(this.getPartitionId(), this.name);
        if (recordStore == null) {
            this.shouldBackup = false;
            return;
        }
        this.numberOfClearedEntries = recordStore.clear();
    }

    @Override
    public boolean shouldBackup() {
        return this.shouldBackup;
    }

    @Override
    public int getSyncBackupCount() {
        return this.mapService.getMapContainer(this.name).getBackupCount();
    }

    @Override
    public int getAsyncBackupCount() {
        return this.mapService.getMapContainer(this.name).getAsyncBackupCount();
    }

    @Override
    public boolean returnsResponse() {
        return true;
    }

    @Override
    public Object getResponse() {
        return this.numberOfClearedEntries;
    }

    @Override
    public Operation getBackupOperation() {
        ClearBackupOperation clearBackupOperation = new ClearBackupOperation(this.name);
        clearBackupOperation.setServiceName("hz:impl:mapService");
        return clearBackupOperation;
    }

    public String toString() {
        return "ClearOperation{}";
    }
}

