/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.writebehind;

import com.hazelcast.map.writebehind.WriteBehindQueue;
import com.hazelcast.map.writebehind.WriteBehindQueues;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

class ArrayWriteBehindQueue<T>
implements WriteBehindQueue<T> {
    private static final int INITIAL_CAPACITY = 16;
    protected List<T> list;

    ArrayWriteBehindQueue() {
        this.list = new ArrayList<T>(16);
    }

    ArrayWriteBehindQueue(List<T> list) {
        if (list == null) {
            throw new NullPointerException();
        }
        this.list = list;
    }

    @Override
    public boolean offer(T entry) {
        return this.list.add(entry);
    }

    @Override
    public void removeFirst() {
        if (this.list.isEmpty()) {
            return;
        }
        this.list.remove(0);
    }

    @Override
    public T get(int index) {
        int size = this.list.size();
        if (index >= size || index < 0) {
            return null;
        }
        return this.list.get(index);
    }

    @Override
    public T remove(int index) {
        int size = this.list.size();
        if (index >= size || index < 0) {
            return null;
        }
        return this.list.remove(index);
    }

    @Override
    public int size() {
        return this.list.size();
    }

    @Override
    public void clear() {
        this.list.clear();
    }

    @Override
    public WriteBehindQueue<T> getSnapShot() {
        if (this.list == null || this.list.isEmpty()) {
            return WriteBehindQueues.emptyWriteBehindQueue();
        }
        return new ArrayWriteBehindQueue<T>(new ArrayList<T>(this.list));
    }

    @Override
    public void addFront(Collection<T> collection) {
        if (collection == null || collection.isEmpty()) {
            return;
        }
        ArrayList<T> newList = new ArrayList<T>();
        newList.addAll(collection);
        newList.addAll(this.list);
        this.list = newList;
    }

    @Override
    public void addEnd(Collection<T> collection) {
        if (collection == null || collection.isEmpty()) {
            return;
        }
        for (T e : collection) {
            this.offer(e);
        }
    }

    @Override
    public List<T> removeAll() {
        List<T> list = this.asList();
        this.list.clear();
        return list;
    }

    @Override
    public boolean isEnabled() {
        return true;
    }

    @Override
    public List<T> asList() {
        if (this.list.isEmpty()) {
            Collections.emptyList();
        }
        return new ArrayList<T>(this.list);
    }

    @Override
    public void shrink() {
        ((ArrayList)this.list).trimToSize();
    }
}

