/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.writebehind.store;

import com.hazelcast.core.MapStore;
import com.hazelcast.logging.ILogger;
import com.hazelcast.map.MapService;
import com.hazelcast.map.writebehind.DelayedEntry;
import com.hazelcast.map.writebehind.store.MapStoreManager;
import com.hazelcast.map.writebehind.store.StoreEvent;
import com.hazelcast.map.writebehind.store.StoreListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;

class DefaultMapStoreManager
implements MapStoreManager<DelayedEntry> {
    private static final int RETRY_TIMES_OF_A_FAILED_STORE_OPERATION = 3;
    private static final int RETRY_STORE_AFTER_WAIT_SECONDS = 1;
    private final MapService mapService;
    private final MapStore mapStore;
    private final List<StoreListener> storeListeners;
    private final ILogger logger;

    DefaultMapStoreManager(MapService mapService, MapStore mapStore, List<StoreListener> listeners) {
        if (listeners == null) {
            throw new IllegalArgumentException("First, set store listeners.");
        }
        this.mapService = mapService;
        this.mapStore = mapStore;
        this.storeListeners = listeners;
        this.logger = mapService.getNodeEngine().getLogger(DefaultMapStoreManager.class);
    }

    @Override
    public Map<Integer, List<DelayedEntry>> process(List<DelayedEntry> delayedEntries) {
        if (delayedEntries == null || delayedEntries.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap<Integer, List<DelayedEntry>> failsPerPartition = new HashMap<Integer, List<DelayedEntry>>();
        ArrayList<DelayedEntry> entriesToProcess = new ArrayList<DelayedEntry>();
        StoreOperationType operationType = null;
        for (DelayedEntry entry : delayedEntries) {
            StoreOperationType previousOperationType = operationType;
            operationType = entry.getValue() == null ? StoreOperationType.DELETE : StoreOperationType.WRITE;
            if (previousOperationType != null && !previousOperationType.equals((Object)operationType)) {
                List<DelayedEntry> failures = this.callHandler(entriesToProcess, previousOperationType);
                this.addToFails(failures, failsPerPartition);
                entriesToProcess.clear();
            }
            entriesToProcess.add(entry);
        }
        List<DelayedEntry> failures = this.callHandler(entriesToProcess, operationType);
        this.addToFails(failures, failsPerPartition);
        entriesToProcess.clear();
        return failsPerPartition;
    }

    private void addToFails(List<DelayedEntry> fails, Map<Integer, List<DelayedEntry>> failsPerPartition) {
        if (fails == null || fails.isEmpty()) {
            return;
        }
        for (DelayedEntry entry : fails) {
            int partitionId = entry.getPartitionId();
            List<DelayedEntry> delayedEntriesPerPartition = failsPerPartition.get(partitionId);
            if (delayedEntriesPerPartition == null) {
                delayedEntriesPerPartition = new ArrayList<DelayedEntry>();
                failsPerPartition.put(partitionId, delayedEntriesPerPartition);
            }
            delayedEntriesPerPartition.add(entry);
        }
    }

    private List<DelayedEntry> callHandler(Collection<DelayedEntry> delayedEntries, StoreOperationType operationType) {
        int size = delayedEntries.size();
        if (size == 0) {
            return Collections.emptyList();
        }
        if (size == 1) {
            Iterator<DelayedEntry> iterator = delayedEntries.iterator();
            DelayedEntry delayedEntry = iterator.next();
            return this.callSingleStoreWithListeners(delayedEntry, operationType);
        }
        DelayedEntry[] delayedEntriesArray = delayedEntries.toArray(new DelayedEntry[delayedEntries.size()]);
        Map batchMap = this.prepareBatchMap(delayedEntriesArray);
        if (batchMap.size() == 1) {
            DelayedEntry delayedEntry = delayedEntriesArray[delayedEntriesArray.length - 1];
            return this.callSingleStoreWithListeners(delayedEntry, operationType);
        }
        List<DelayedEntry> failedEntryList = this.callBatchStoreWithListeners(batchMap, operationType);
        ArrayList<DelayedEntry> failedTries = new ArrayList<DelayedEntry>();
        for (DelayedEntry entry : failedEntryList) {
            List<DelayedEntry> tmpFails = this.callSingleStoreWithListeners(entry, operationType);
            failedTries.addAll(tmpFails);
        }
        return failedTries;
    }

    private Map prepareBatchMap(DelayedEntry[] delayedEntries) {
        HashMap<Object, DelayedEntry> batchMap = new HashMap<Object, DelayedEntry>();
        int length = delayedEntries.length;
        for (int i = length - 1; i >= 0; --i) {
            DelayedEntry delayedEntry = delayedEntries[i];
            Object key = delayedEntry.getKey();
            if (batchMap.containsKey(key)) continue;
            batchMap.put(key, delayedEntry);
        }
        return batchMap;
    }

    private List<DelayedEntry> callSingleStoreWithListeners(final DelayedEntry entry, final StoreOperationType operationType) {
        return this.retryCall(new RetryTask<DelayedEntry>(){
            private List<DelayedEntry> failedDelayedEntries = Collections.emptyList();

            @Override
            public boolean run() throws Exception {
                DefaultMapStoreManager.this.callBeforeStoreListeners(entry);
                Object key = DefaultMapStoreManager.this.toObject(entry.getKey());
                Object value = DefaultMapStoreManager.this.toObject(entry.getValue());
                boolean result = operationType.processSingle(key, value, DefaultMapStoreManager.this.mapStore);
                DefaultMapStoreManager.this.callAfterStoreListeners(entry);
                return result;
            }

            @Override
            public List<DelayedEntry> failedList() {
                this.failedDelayedEntries = Collections.singletonList(entry);
                return this.failedDelayedEntries;
            }
        });
    }

    private Map convertToObject(Map<Object, DelayedEntry> batchMap) {
        HashMap<Object, Object> map = new HashMap<Object, Object>();
        for (DelayedEntry entry : batchMap.values()) {
            Object key = this.mapService.toObject(entry.getKey());
            Object value = this.mapService.toObject(entry.getValue());
            map.put(key, value);
        }
        return map;
    }

    private List<DelayedEntry> callBatchStoreWithListeners(final Map<Object, DelayedEntry> batchMap, final StoreOperationType operationType) {
        return this.retryCall(new RetryTask<DelayedEntry>(){
            private List<DelayedEntry> failedDelayedEntries = Collections.emptyList();

            @Override
            public boolean run() throws Exception {
                DefaultMapStoreManager.this.callBeforeStoreListeners(batchMap.values());
                Map map = DefaultMapStoreManager.this.convertToObject(batchMap);
                boolean result = operationType.processBatch(map, DefaultMapStoreManager.this.mapStore);
                DefaultMapStoreManager.this.callAfterStoreListeners(batchMap.values());
                return result;
            }

            @Override
            public List<DelayedEntry> failedList() {
                this.failedDelayedEntries = new ArrayList<DelayedEntry>(batchMap.values().size());
                this.failedDelayedEntries.addAll(batchMap.values());
                return this.failedDelayedEntries;
            }
        });
    }

    private Object toObject(Object o) {
        return this.mapService.toObject(o);
    }

    private void callBeforeStoreListeners(DelayedEntry entry) {
        for (StoreListener listener : this.storeListeners) {
            listener.beforeStore(StoreEvent.createStoreEvent(entry));
        }
    }

    private void callAfterStoreListeners(DelayedEntry entry) {
        for (StoreListener listener : this.storeListeners) {
            listener.afterStore(StoreEvent.createStoreEvent(entry));
        }
    }

    @Override
    public void callBeforeStoreListeners(Collection<DelayedEntry> entries) {
        for (DelayedEntry entry : entries) {
            this.callBeforeStoreListeners(entry);
        }
    }

    @Override
    public void callAfterStoreListeners(Collection<DelayedEntry> entries) {
        for (DelayedEntry entry : entries) {
            this.callAfterStoreListeners(entry);
        }
    }

    private List<DelayedEntry> retryCall(RetryTask task) {
        int k;
        boolean result = false;
        Throwable throwable = null;
        for (k = 0; k < 3; ++k) {
            try {
                result = task.run();
            }
            catch (Throwable t) {
                throwable = t;
            }
            if (result) break;
            this.sleepSeconds(1L);
        }
        if (k > 0) {
            String msg = String.format("Store operation failed and retries %s", result ? "succeeded." : "failed too.");
            this.logger.warning(msg, throwable);
            if (!result) {
                return task.failedList();
            }
        }
        return Collections.emptyList();
    }

    private void sleepSeconds(long secs) {
        try {
            TimeUnit.SECONDS.sleep(secs);
        }
        catch (InterruptedException e) {
            this.logger.warning(e);
        }
    }

    private static enum StoreOperationType {
        DELETE{

            @Override
            boolean processSingle(Object key, Object value, MapStore mapStore) {
                mapStore.delete(key);
                return true;
            }

            @Override
            boolean processBatch(Map map, MapStore mapStore) {
                mapStore.deleteAll(map.keySet());
                return true;
            }
        }
        ,
        WRITE{

            @Override
            boolean processSingle(Object key, Object value, MapStore mapStore) {
                mapStore.store(key, value);
                return true;
            }

            @Override
            boolean processBatch(Map map, MapStore mapStore) {
                mapStore.storeAll(map);
                return true;
            }
        };


        abstract boolean processSingle(Object var1, Object var2, MapStore var3);

        abstract boolean processBatch(Map var1, MapStore var2);
    }

    private static interface RetryTask<T> {
        public boolean run() throws Exception;

        public List<T> failedList();
    }
}

