/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.nio.serialization;

import com.hazelcast.nio.BufferObjectDataInput;
import com.hazelcast.nio.DynamicByteBuffer;
import com.hazelcast.nio.UTFEncoderDecoder;
import com.hazelcast.nio.serialization.ClassDefinition;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.nio.serialization.PortableContext;
import com.hazelcast.nio.serialization.PortableContextAware;
import com.hazelcast.nio.serialization.PortableContextAwareInputStream;
import com.hazelcast.nio.serialization.SerializationService;
import java.io.EOFException;
import java.io.IOException;
import java.nio.ByteOrder;

final class ByteBufferObjectDataInput
extends PortableContextAwareInputStream
implements BufferObjectDataInput,
PortableContextAware {
    private static final int UTF_BUFFER_SIZE = 1024;
    private final DynamicByteBuffer buffer;
    private final SerializationService service;
    private byte[] utfBuffer;

    ByteBufferObjectDataInput(Data data, SerializationService service, ByteOrder order) {
        this(data.buffer, service, order);
        ClassDefinition cd = data.classDefinition;
        this.setClassDefinition(cd);
    }

    ByteBufferObjectDataInput(byte[] buffer, SerializationService service, ByteOrder order) {
        this.buffer = new DynamicByteBuffer(buffer);
        this.buffer.order(order);
        this.service = service;
    }

    @Override
    public int read() throws IOException {
        return this.buffer.hasRemaining() ? (int)this.buffer.get() : -1;
    }

    @Override
    public int read(int position) throws IOException {
        return this.buffer.hasRemaining() ? (int)this.buffer.get(position) : -1;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int size;
        if (b == null) {
            throw new NullPointerException();
        }
        if (len <= 0) {
            return 0;
        }
        int pos = this.buffer.position();
        if (pos >= (size = this.buffer.capacity())) {
            return -1;
        }
        if (pos + len > size) {
            len = size - pos;
        }
        this.buffer.get(b, off, len);
        return len;
    }

    @Override
    public boolean readBoolean() throws IOException {
        byte ch = this.readByte();
        return ch != 0;
    }

    @Override
    public boolean readBoolean(int position) throws IOException {
        byte ch = this.readByte(position);
        return ch != 0;
    }

    @Override
    public byte readByte() throws IOException {
        int ch = this.read();
        if (ch < 0) {
            throw new EOFException();
        }
        return (byte)ch;
    }

    @Override
    public byte readByte(int position) throws IOException {
        int ch = this.read(position);
        if (ch < 0) {
            throw new EOFException();
        }
        return (byte)ch;
    }

    @Override
    public char readChar() throws IOException {
        return this.buffer.getChar();
    }

    @Override
    public char readChar(int position) throws IOException {
        return this.buffer.getChar(position);
    }

    @Override
    public double readDouble() throws IOException {
        return this.buffer.getDouble();
    }

    @Override
    public double readDouble(int position) throws IOException {
        return this.buffer.getDouble(position);
    }

    @Override
    public float readFloat() throws IOException {
        return this.buffer.getFloat();
    }

    @Override
    public float readFloat(int position) throws IOException {
        return this.buffer.getFloat(position);
    }

    @Override
    public void readFully(byte[] b) throws IOException {
        this.read(b);
    }

    @Override
    public void readFully(byte[] b, int off, int len) throws IOException {
        this.read(b, off, len);
    }

    @Override
    public int readInt() throws IOException {
        return this.buffer.getInt();
    }

    @Override
    public int readInt(int position) throws IOException {
        return this.buffer.getInt(position);
    }

    @Override
    @Deprecated
    public String readLine() throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public long readLong() throws IOException {
        return this.buffer.getLong();
    }

    @Override
    public long readLong(int position) throws IOException {
        return this.buffer.getLong(position);
    }

    @Override
    public short readShort() throws IOException {
        return this.buffer.getShort();
    }

    @Override
    public short readShort(int position) throws IOException {
        return this.buffer.getShort(position);
    }

    @Override
    public char[] readCharArray() throws IOException {
        int len = this.readInt();
        if (len > 0) {
            char[] values = new char[len];
            for (int i = 0; i < len; ++i) {
                values[i] = this.readChar();
            }
            return values;
        }
        return new char[0];
    }

    @Override
    public int[] readIntArray() throws IOException {
        int len = this.readInt();
        if (len > 0) {
            int[] values = new int[len];
            for (int i = 0; i < len; ++i) {
                values[i] = this.readInt();
            }
            return values;
        }
        return new int[0];
    }

    @Override
    public long[] readLongArray() throws IOException {
        int len = this.readInt();
        if (len > 0) {
            long[] values = new long[len];
            for (int i = 0; i < len; ++i) {
                values[i] = this.readLong();
            }
            return values;
        }
        return new long[0];
    }

    @Override
    public double[] readDoubleArray() throws IOException {
        int len = this.readInt();
        if (len > 0) {
            double[] values = new double[len];
            for (int i = 0; i < len; ++i) {
                values[i] = this.readDouble();
            }
            return values;
        }
        return new double[0];
    }

    @Override
    public float[] readFloatArray() throws IOException {
        int len = this.readInt();
        if (len > 0) {
            float[] values = new float[len];
            for (int i = 0; i < len; ++i) {
                values[i] = this.readFloat();
            }
            return values;
        }
        return new float[0];
    }

    @Override
    public short[] readShortArray() throws IOException {
        int len = this.readInt();
        if (len > 0) {
            short[] values = new short[len];
            for (int i = 0; i < len; ++i) {
                values[i] = this.readShort();
            }
            return values;
        }
        return new short[0];
    }

    @Override
    public int readUnsignedByte() throws IOException {
        return this.readByte();
    }

    @Override
    public int readUnsignedShort() throws IOException {
        return this.buffer.getShort();
    }

    @Override
    public String readUTF() throws IOException {
        if (this.utfBuffer == null) {
            this.utfBuffer = new byte[1024];
        }
        return UTFEncoderDecoder.readUTF(this, this.utfBuffer);
    }

    public Object readObject() throws IOException {
        return this.service.readObject(this);
    }

    @Override
    public long skip(long n) {
        if (n <= 0L || n >= Integer.MAX_VALUE) {
            return 0L;
        }
        return this.skipBytes((int)n);
    }

    @Override
    public int skipBytes(int n) {
        int cap;
        if (n <= 0) {
            return 0;
        }
        int skip = n;
        int pos = this.position();
        if (pos + skip > (cap = this.buffer.capacity())) {
            skip = cap - pos;
        }
        this.position(pos + skip);
        return skip;
    }

    public byte[] getBuffer() {
        return this.buffer.array();
    }

    @Override
    public int position() {
        return this.buffer.position();
    }

    @Override
    public void position(int newPos) {
        this.buffer.position(newPos);
    }

    @Override
    public int available() {
        return this.buffer.remaining();
    }

    @Override
    public boolean markSupported() {
        return true;
    }

    @Override
    public void mark(int readlimit) {
        this.buffer.mark();
    }

    @Override
    public void reset() {
        this.buffer.reset();
    }

    @Override
    public void close() {
        this.buffer.close();
    }

    @Override
    public PortableContext getPortableContext() {
        return this.service.getPortableContext();
    }

    @Override
    public ClassLoader getClassLoader() {
        return this.service.getClassLoader();
    }

    @Override
    public ByteOrder getByteOrder() {
        return this.buffer.order();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("ByteBufferObjectDataInput{");
        sb.append("buffer=").append(this.buffer);
        sb.append('}');
        return sb.toString();
    }
}

