/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client;

import com.hazelcast.client.ClientEndpoint;
import com.hazelcast.client.ClientEngineImpl;
import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.Logger;
import com.hazelcast.nio.Connection;
import com.hazelcast.spi.NodeEngine;
import com.hazelcast.util.UuidUtil;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import javax.security.auth.login.LoginException;

public class ClientEndpointManager {
    private static final ILogger LOGGER = Logger.getLogger(ClientEndpointManager.class);
    private static final int DESTROY_ENDPOINT_DELAY_MS = 1111;
    private final ClientEngineImpl clientEngine;
    private final NodeEngine nodeEngine;
    private final ConcurrentMap<Connection, ClientEndpoint> endpoints = new ConcurrentHashMap<Connection, ClientEndpoint>();

    public ClientEndpointManager(ClientEngineImpl clientEngine, NodeEngine nodeEngine) {
        this.clientEngine = clientEngine;
        this.nodeEngine = nodeEngine;
    }

    Set<ClientEndpoint> getEndpoints(String uuid) {
        HashSet<ClientEndpoint> endpointSet = new HashSet<ClientEndpoint>();
        for (ClientEndpoint endpoint : this.endpoints.values()) {
            if (!uuid.equals(endpoint.getUuid())) continue;
            endpointSet.add(endpoint);
        }
        return endpointSet;
    }

    ClientEndpoint getEndpoint(Connection conn) {
        return (ClientEndpoint)this.endpoints.get(conn);
    }

    ClientEndpoint createEndpoint(Connection conn) {
        if (!conn.live()) {
            LOGGER.severe("Can't create and endpoint for a dead connection");
            return null;
        }
        String clientUuid = UuidUtil.createClientUuid(conn.getEndPoint());
        ClientEndpoint endpoint = new ClientEndpoint(this.clientEngine, conn, clientUuid);
        if (this.endpoints.putIfAbsent(conn, endpoint) != null) {
            LOGGER.severe("An endpoint already exists for connection:" + conn);
        }
        return endpoint;
    }

    void removeEndpoint(ClientEndpoint endpoint) {
        this.removeEndpoint(endpoint, false);
    }

    void removeEndpoint(ClientEndpoint endpoint, boolean closeImmediately) {
        this.endpoints.remove(endpoint.getConnection());
        LOGGER.info("Destroying " + endpoint);
        try {
            endpoint.destroy();
        }
        catch (LoginException e) {
            LOGGER.warning(e);
        }
        final Connection connection = endpoint.getConnection();
        if (closeImmediately) {
            try {
                connection.close();
            }
            catch (Throwable e) {
                LOGGER.warning("While closing client connection: " + connection, e);
            }
        } else {
            this.nodeEngine.getExecutionService().schedule(new Runnable(){

                @Override
                public void run() {
                    if (connection.live()) {
                        try {
                            connection.close();
                        }
                        catch (Throwable e) {
                            LOGGER.warning("While closing client connection: " + e.toString());
                        }
                    }
                }
            }, 1111L, TimeUnit.MILLISECONDS);
        }
        this.clientEngine.sendClientEvent(endpoint);
    }

    void removeEndpoints(String memberUuid) {
        Iterator iterator = this.endpoints.values().iterator();
        while (iterator.hasNext()) {
            ClientEndpoint endpoint = (ClientEndpoint)iterator.next();
            String ownerUuid = endpoint.getPrincipal().getOwnerUuid();
            if (!memberUuid.equals(ownerUuid)) continue;
            iterator.remove();
            this.removeEndpoint(endpoint, true);
        }
    }

    void clear() {
        this.endpoints.clear();
    }

    Collection<ClientEndpoint> values() {
        return this.endpoints.values();
    }

    int size() {
        return this.endpoints.size();
    }
}

