/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.concurrent.atomiclong.client;

import com.hazelcast.client.PartitionClientRequest;
import com.hazelcast.client.SecureRequest;
import com.hazelcast.concurrent.atomiclong.client.AtomicLongPortableHook;
import com.hazelcast.core.IFunction;
import com.hazelcast.nio.IOUtil;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.nio.serialization.Portable;
import com.hazelcast.nio.serialization.PortableReader;
import com.hazelcast.nio.serialization.PortableWriter;
import com.hazelcast.security.permission.AtomicLongPermission;
import java.io.IOException;
import java.security.Permission;

public abstract class AbstractAlterRequest
extends PartitionClientRequest
implements Portable,
SecureRequest {
    protected String name;
    protected Data function;

    public AbstractAlterRequest() {
    }

    public AbstractAlterRequest(String name, Data function) {
        this.name = name;
        this.function = function;
    }

    @Override
    protected int getPartition() {
        Data key = this.serializationService.toData(this.name);
        return this.getClientEngine().getPartitionService().getPartitionId(key);
    }

    @Override
    public String getServiceName() {
        return "hz:impl:atomicLongService";
    }

    @Override
    public int getFactoryId() {
        return AtomicLongPortableHook.F_ID;
    }

    @Override
    public void write(PortableWriter writer) throws IOException {
        writer.writeUTF("n", this.name);
        ObjectDataOutput out = writer.getRawDataOutput();
        IOUtil.writeNullableData(out, this.function);
    }

    @Override
    public void read(PortableReader reader) throws IOException {
        this.name = reader.readUTF("n");
        ObjectDataInput in = reader.getRawDataInput();
        this.function = IOUtil.readNullableData(in);
    }

    protected IFunction<Long, Long> getFunction() {
        return (IFunction)this.serializationService.toObject(this.function);
    }

    @Override
    public Permission getRequiredPermission() {
        return new AtomicLongPermission(this.name, "modify");
    }

    @Override
    public String getDistributedObjectName() {
        return this.name;
    }

    @Override
    public Object[] getParameters() {
        return new Object[]{this.function};
    }
}

