/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.eviction;

import com.hazelcast.map.MapServiceContext;
import com.hazelcast.map.PartitionContainer;
import com.hazelcast.map.RecordStore;
import com.hazelcast.map.operation.ClearExpiredOperation;
import com.hazelcast.partition.InternalPartition;
import com.hazelcast.spi.NodeEngine;
import com.hazelcast.spi.Operation;
import com.hazelcast.spi.OperationService;
import com.hazelcast.util.Clock;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;

public class ExpirationManager {
    private static final long INITIAL_DELAY = 5L;
    private static final long PERIOD = 5L;
    private static final TimeUnit UNIT = TimeUnit.SECONDS;
    private final NodeEngine nodeEngine;
    private final MapServiceContext mapServiceContext;

    public ExpirationManager(MapServiceContext mapServiceContext, NodeEngine nodeEngine) {
        this.nodeEngine = nodeEngine;
        this.mapServiceContext = mapServiceContext;
    }

    public void start() {
        this.nodeEngine.getExecutionService().scheduleAtFixedRate(new ClearExpiredRecordsTask(), 5L, 5L, UNIT);
    }

    private Operation createExpirationOperation(int expirationPercentage, int partitionId) {
        ClearExpiredOperation clearExpiredOperation = new ClearExpiredOperation(expirationPercentage);
        clearExpiredOperation.setNodeEngine(this.nodeEngine).setCallerUuid(this.nodeEngine.getLocalMember().getUuid()).setPartitionId(partitionId).setValidateTarget(false).setService(this.mapServiceContext.getService());
        return clearExpiredOperation;
    }

    private class ClearExpiredRecordsTask
    implements Runnable {
        private static final int EXPIRATION_PERCENTAGE = 10;
        private static final long MIN_MILLIS_DIFF_BETWEEN_TWO_RUNS = 1000L;
        private final Comparator<PartitionContainer> partitionContainerComparator = new Comparator<PartitionContainer>(){

            @Override
            public int compare(PartitionContainer o1, PartitionContainer o2) {
                long s2;
                long s1 = o1.getLastCleanupTime();
                return s1 < (s2 = o2.getLastCleanupTime()) ? -1 : (s1 == s2 ? 0 : 1);
            }
        };

        private ClearExpiredRecordsTask() {
        }

        @Override
        public void run() {
            long now = Clock.currentTimeMillis();
            NodeEngine nodeEngine = ExpirationManager.this.nodeEngine;
            int partitionCount = nodeEngine.getPartitionService().getPartitionCount();
            List<PartitionContainer> partitionContainers = Collections.emptyList();
            boolean createLazy = true;
            int currentlyRunningCleanupOperationsCount = 0;
            for (int partitionId = 0; partitionId < partitionCount; ++partitionId) {
                PartitionContainer partitionContainer;
                InternalPartition partition = nodeEngine.getPartitionService().getPartition(partitionId);
                if (!partition.isOwnerOrBackup(nodeEngine.getThisAddress()) || this.isContainerEmpty(partitionContainer = ExpirationManager.this.mapServiceContext.getPartitionContainer(partitionId))) continue;
                if (this.hasRunningCleanup(partitionContainer)) {
                    ++currentlyRunningCleanupOperationsCount;
                    continue;
                }
                if (currentlyRunningCleanupOperationsCount > this.getMaxCleanupOperationCountInOneRound() || this.notInProcessableTimeWindow(partitionContainer, now) || this.notAnyExpirableRecord(partitionContainer)) continue;
                if (createLazy) {
                    partitionContainers = new ArrayList<PartitionContainer>();
                    createLazy = false;
                }
                partitionContainers.add(partitionContainer);
            }
            if (partitionContainers.isEmpty()) {
                return;
            }
            Collections.sort(partitionContainers, this.partitionContainerComparator);
            this.sendCleanupOperations(partitionContainers);
        }

        private void sendCleanupOperations(List<PartitionContainer> partitionContainers) {
            int maxCleanupOperationCountInOneRound = this.getMaxCleanupOperationCountInOneRound();
            boolean start = false;
            int end = maxCleanupOperationCountInOneRound;
            if (end > partitionContainers.size()) {
                end = partitionContainers.size();
            }
            List<PartitionContainer> partitionIds = partitionContainers.subList(0, end);
            for (PartitionContainer container : partitionIds) {
                container.setHasRunningCleanup(true);
                OperationService operationService = ExpirationManager.this.nodeEngine.getOperationService();
                operationService.executeOperation(ExpirationManager.this.createExpirationOperation(10, container.getPartitionId()));
            }
        }

        private boolean expirable(RecordStore recordStore) {
            return recordStore.isExpirable();
        }

        private boolean hasRunningCleanup(PartitionContainer partitionContainer) {
            return partitionContainer.hasRunningCleanup();
        }

        private boolean notInProcessableTimeWindow(PartitionContainer partitionContainer, long now) {
            return now - partitionContainer.getLastCleanupTime() < 1000L;
        }

        private int getMaxCleanupOperationCountInOneRound() {
            int times = 3;
            return 3 * ExpirationManager.this.nodeEngine.getOperationService().getPartitionOperationThreadCount();
        }

        private boolean isContainerEmpty(PartitionContainer container) {
            long size = 0L;
            ConcurrentMap<String, RecordStore> maps = container.getMaps();
            for (RecordStore store : maps.values()) {
                if ((size += (long)store.size()) <= 0L) continue;
                return false;
            }
            return true;
        }

        private boolean notAnyExpirableRecord(PartitionContainer partitionContainer) {
            boolean notExist = true;
            ConcurrentMap<String, RecordStore> maps = partitionContainer.getMaps();
            for (RecordStore store : maps.values()) {
                if (!this.expirable(store)) continue;
                notExist = false;
                break;
            }
            return notExist;
        }
    }
}

