/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.mapstore;

import com.hazelcast.map.MapContainer;
import com.hazelcast.map.MapServiceContext;
import com.hazelcast.map.MapStoreWrapper;
import com.hazelcast.map.mapstore.EmptyMapDataStore;
import com.hazelcast.map.mapstore.MapDataStore;
import com.hazelcast.map.mapstore.writebehind.WriteBehindProcessor;
import com.hazelcast.map.mapstore.writebehind.WriteBehindStore;
import com.hazelcast.map.mapstore.writethrough.WriteThroughStore;
import com.hazelcast.nio.serialization.SerializationService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

public final class MapDataStores {
    private MapDataStores() {
    }

    public static <K, V> MapDataStore<K, V> createWriteBehindStore(MapContainer mapContainer, int partitionId, WriteBehindProcessor writeBehindProcessor) {
        MapServiceContext mapServiceContext = mapContainer.getMapServiceContext();
        MapStoreWrapper store = mapContainer.getStore();
        SerializationService serializationService = mapServiceContext.getNodeEngine().getSerializationService();
        int writeDelaySeconds = mapContainer.getMapConfig().getMapStoreConfig().getWriteDelaySeconds();
        long millis = mapServiceContext.convertTime(writeDelaySeconds, TimeUnit.SECONDS);
        int capacity = mapServiceContext.getNodeEngine().getGroupProperties().MAP_WRITE_BEHIND_QUEUE_CAPACITY.getInteger();
        AtomicInteger writeBehindQueueItemCounter = mapServiceContext.getWriteBehindQueueItemCounter();
        WriteBehindStore mapDataStore = new WriteBehindStore(store, serializationService, millis, partitionId, capacity, writeBehindQueueItemCounter);
        mapDataStore.setWriteBehindProcessor(writeBehindProcessor);
        return mapDataStore;
    }

    public static <K, V> MapDataStore<K, V> createWriteThroughStore(MapContainer mapContainer) {
        return new WriteThroughStore(mapContainer.getStore(), mapContainer.getMapServiceContext().getNodeEngine().getSerializationService());
    }

    public static <K, V> MapDataStore<K, V> emptyStore() {
        return EmptyStoreHolder.EMPTY;
    }

    private static class EmptyStoreHolder {
        static final MapDataStore EMPTY = new EmptyMapDataStore();

        private EmptyStoreHolder() {
        }
    }
}

