/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.operation;

import com.hazelcast.core.EntryEventType;
import com.hazelcast.core.EntryView;
import com.hazelcast.map.EntryViews;
import com.hazelcast.map.MapEventPublisher;
import com.hazelcast.map.MapService;
import com.hazelcast.map.MapServiceContext;
import com.hazelcast.map.RecordStore;
import com.hazelcast.map.operation.AbstractMapOperation;
import com.hazelcast.map.operation.PutFromLoadAllBackupOperation;
import com.hazelcast.map.record.Record;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.spi.BackupAwareOperation;
import com.hazelcast.spi.Operation;
import com.hazelcast.spi.PartitionAwareOperation;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class PutFromLoadAllOperation
extends AbstractMapOperation
implements PartitionAwareOperation,
BackupAwareOperation {
    private List<Data> keyValueSequence;

    public PutFromLoadAllOperation() {
        this.keyValueSequence = Collections.emptyList();
    }

    public PutFromLoadAllOperation(String name, List<Data> keyValueSequence) {
        super(name);
        this.keyValueSequence = keyValueSequence;
    }

    @Override
    public void run() throws Exception {
        List<Data> keyValueSequence = this.keyValueSequence;
        if (keyValueSequence == null || keyValueSequence.isEmpty()) {
            return;
        }
        int partitionId = this.getPartitionId();
        MapService mapService = this.mapService;
        RecordStore recordStore = mapService.getMapServiceContext().getRecordStore(partitionId, this.name);
        for (int i = 0; i < keyValueSequence.size(); i += 2) {
            Data key = keyValueSequence.get(i);
            Data dataValue = keyValueSequence.get(i + 1);
            Object objectValue = mapService.getMapServiceContext().toObject(dataValue);
            Object previousValue = recordStore.putFromLoad(key, objectValue);
            this.callAfterPutInterceptors(objectValue);
            this.publishEntryEvent(key, mapService.getMapServiceContext().toData(previousValue), dataValue);
            this.publishWanReplicationEvent(key, dataValue, recordStore.getRecord(key));
        }
    }

    private void callAfterPutInterceptors(Object value) {
        this.mapService.getMapServiceContext().interceptAfterPut(this.name, value);
    }

    private void publishEntryEvent(Data key, Data previousValue, Data newValue) {
        EntryEventType eventType = previousValue == null ? EntryEventType.ADDED : EntryEventType.UPDATED;
        MapServiceContext mapServiceContext = this.mapService.getMapServiceContext();
        MapEventPublisher mapEventPublisher = mapServiceContext.getMapEventPublisher();
        mapEventPublisher.publishEvent(this.getCallerAddress(), this.name, eventType, key, previousValue, newValue);
    }

    private void publishWanReplicationEvent(Data key, Data value, Record record) {
        if (this.mapContainer.getWanReplicationPublisher() != null && this.mapContainer.getWanMergePolicy() != null) {
            EntryView<Data, Data> entryView = EntryViews.createSimpleEntryView(key, value, record);
            this.mapService.getMapServiceContext().getMapEventPublisher().publishWanReplicationUpdate(this.name, entryView);
        }
    }

    @Override
    public void afterRun() throws Exception {
        List<Data> keyValueSequence = this.keyValueSequence;
        if (keyValueSequence == null || keyValueSequence.isEmpty()) {
            return;
        }
        int size = keyValueSequence.size();
        ArrayList<Data> dataKeys = new ArrayList<Data>(size / 2);
        for (int i = 0; i < size; i += 2) {
            Data key = keyValueSequence.get(i);
            dataKeys.add(key);
        }
        this.mapService.getMapServiceContext().getNearCacheProvider().invalidateNearCache(this.name, dataKeys);
    }

    @Override
    public boolean returnsResponse() {
        return true;
    }

    @Override
    public Object getResponse() {
        return true;
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        super.writeInternal(out);
        List<Data> keyValueSequence = this.keyValueSequence;
        int size = keyValueSequence.size();
        out.writeInt(size);
        for (Data data : keyValueSequence) {
            data.writeData(out);
        }
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        super.readInternal(in);
        int size = in.readInt();
        if (size < 1) {
            this.keyValueSequence = Collections.emptyList();
        } else {
            ArrayList<Data> tmpKeyValueSequence = new ArrayList<Data>(size);
            for (int i = 0; i < size; ++i) {
                Data data = new Data();
                data.readData(in);
                tmpKeyValueSequence.add(data);
            }
            this.keyValueSequence = tmpKeyValueSequence;
        }
    }

    @Override
    public boolean shouldBackup() {
        return !this.keyValueSequence.isEmpty();
    }

    @Override
    public final int getAsyncBackupCount() {
        return this.mapContainer.getAsyncBackupCount();
    }

    @Override
    public final int getSyncBackupCount() {
        return this.mapContainer.getBackupCount();
    }

    @Override
    public Operation getBackupOperation() {
        return new PutFromLoadAllBackupOperation(this.name, this.keyValueSequence);
    }

    public String toString() {
        return "PutFromLoadAllOperation{}";
    }
}

