/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.mapreduce.impl.client;

import com.hazelcast.client.ClientEndpoint;
import com.hazelcast.client.InvocationClientRequest;
import com.hazelcast.cluster.ClusterService;
import com.hazelcast.config.JobTrackerConfig;
import com.hazelcast.core.ExecutionCallback;
import com.hazelcast.core.ICompletableFuture;
import com.hazelcast.instance.MemberImpl;
import com.hazelcast.mapreduce.CombinerFactory;
import com.hazelcast.mapreduce.JobTracker;
import com.hazelcast.mapreduce.KeyPredicate;
import com.hazelcast.mapreduce.KeyValueSource;
import com.hazelcast.mapreduce.Mapper;
import com.hazelcast.mapreduce.ReducerFactory;
import com.hazelcast.mapreduce.TopologyChangedStrategy;
import com.hazelcast.mapreduce.impl.AbstractJobTracker;
import com.hazelcast.mapreduce.impl.HashMapAdapter;
import com.hazelcast.mapreduce.impl.MapReducePortableHook;
import com.hazelcast.mapreduce.impl.MapReduceService;
import com.hazelcast.mapreduce.impl.MapReduceUtil;
import com.hazelcast.mapreduce.impl.operation.KeyValueJobOperation;
import com.hazelcast.mapreduce.impl.operation.StartProcessingJobOperation;
import com.hazelcast.mapreduce.impl.task.TrackableJobFuture;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.PortableReader;
import com.hazelcast.nio.serialization.PortableWriter;
import com.hazelcast.spi.AbstractOperation;
import com.hazelcast.spi.NodeEngine;
import java.io.IOException;
import java.security.Permission;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.concurrent.ExecutionException;

public class ClientMapReduceRequest<KeyIn, ValueIn>
extends InvocationClientRequest {
    protected String name;
    protected String jobId;
    protected Collection keys;
    protected KeyPredicate predicate;
    protected Mapper mapper;
    protected CombinerFactory combinerFactory;
    protected ReducerFactory reducerFactory;
    protected KeyValueSource keyValueSource;
    protected int chunkSize;
    protected TopologyChangedStrategy topologyChangedStrategy;

    public ClientMapReduceRequest() {
    }

    public ClientMapReduceRequest(String name, String jobId, Collection keys, KeyPredicate predicate, Mapper mapper, CombinerFactory combinerFactory, ReducerFactory reducerFactory, KeyValueSource keyValueSource, int chunkSize, TopologyChangedStrategy topologyChangedStrategy) {
        this.name = name;
        this.jobId = jobId;
        this.keys = keys;
        this.predicate = predicate;
        this.mapper = mapper;
        this.combinerFactory = combinerFactory;
        this.reducerFactory = reducerFactory;
        this.keyValueSource = keyValueSource;
        this.chunkSize = chunkSize;
        this.topologyChangedStrategy = topologyChangedStrategy;
    }

    @Override
    protected void invoke() {
        try {
            final ClientEndpoint endpoint = this.getEndpoint();
            MapReduceService mapReduceService = (MapReduceService)this.getService();
            NodeEngine nodeEngine = mapReduceService.getNodeEngine();
            AbstractJobTracker jobTracker = (AbstractJobTracker)mapReduceService.createDistributedObject(this.name);
            TrackableJobFuture jobFuture = new TrackableJobFuture(this.name, this.jobId, jobTracker, nodeEngine, null);
            if (jobTracker.registerTrackableJob(jobFuture)) {
                ICompletableFuture<Object> future = this.startSupervisionTask(jobFuture, mapReduceService, nodeEngine, jobTracker);
                future.andThen(new ExecutionCallback<Object>(){

                    @Override
                    public void onResponse(Object response) {
                        HashMapAdapter clientResponse = response;
                        if (clientResponse instanceof HashMap) {
                            clientResponse = new HashMapAdapter(clientResponse);
                        }
                        endpoint.sendResponse(clientResponse, ClientMapReduceRequest.this.getCallId());
                    }

                    @Override
                    public void onFailure(Throwable t) {
                        Throwable throwable = t;
                        if (throwable instanceof ExecutionException) {
                            throwable = throwable.getCause();
                        }
                        endpoint.sendResponse(throwable, ClientMapReduceRequest.this.getCallId());
                    }
                });
            }
        }
        catch (Exception e) {
            throw new IllegalStateException("Could not register map reduce job", e);
        }
    }

    private <T> ICompletableFuture<T> startSupervisionTask(TrackableJobFuture<T> jobFuture, MapReduceService mapReduceService, NodeEngine nodeEngine, JobTracker jobTracker) {
        AbstractOperation operation;
        JobTrackerConfig config = ((AbstractJobTracker)jobTracker).getJobTrackerConfig();
        boolean communicateStats = config.isCommunicateStats();
        if (this.chunkSize == -1) {
            this.chunkSize = config.getChunkSize();
        }
        if (this.topologyChangedStrategy == null) {
            this.topologyChangedStrategy = config.getTopologyChangedStrategy();
        }
        ClusterService cs = nodeEngine.getClusterService();
        Collection<MemberImpl> members = cs.getMemberList();
        for (MemberImpl member : members) {
            operation = new KeyValueJobOperation(this.name, this.jobId, this.chunkSize, this.keyValueSource, this.mapper, this.combinerFactory, this.reducerFactory, communicateStats, this.topologyChangedStrategy);
            MapReduceUtil.executeOperation(operation, member.getAddress(), mapReduceService, nodeEngine);
        }
        for (MemberImpl member : members) {
            operation = new StartProcessingJobOperation(this.name, this.jobId, this.keys, this.predicate);
            MapReduceUtil.executeOperation(operation, member.getAddress(), mapReduceService, nodeEngine);
        }
        return jobFuture;
    }

    @Override
    public void write(PortableWriter writer) throws IOException {
        super.write(writer);
        ObjectDataOutput out = writer.getRawDataOutput();
        this.writeData(out);
    }

    @Override
    public void read(PortableReader reader) throws IOException {
        super.read(reader);
        ObjectDataInput in = reader.getRawDataInput();
        this.readData(in);
    }

    @Override
    public String getServiceName() {
        return "hz:impl:mapReduceService";
    }

    @Override
    public int getFactoryId() {
        return MapReducePortableHook.F_ID;
    }

    @Override
    public int getClassId() {
        return 3;
    }

    private void writeData(ObjectDataOutput out) throws IOException {
        out.writeUTF(this.name);
        out.writeUTF(this.jobId);
        out.writeObject(this.predicate);
        out.writeObject(this.mapper);
        out.writeObject(this.combinerFactory);
        out.writeObject(this.reducerFactory);
        out.writeObject(this.keyValueSource);
        out.writeInt(this.chunkSize);
        out.writeInt(this.keys == null ? 0 : this.keys.size());
        if (this.keys != null) {
            for (Object key : this.keys) {
                out.writeObject(key);
            }
        }
        out.writeBoolean(this.topologyChangedStrategy != null);
        if (this.topologyChangedStrategy != null) {
            out.writeInt(this.topologyChangedStrategy.ordinal());
        }
    }

    private void readData(ObjectDataInput in) throws IOException {
        this.name = in.readUTF();
        this.jobId = in.readUTF();
        this.predicate = (KeyPredicate)in.readObject();
        this.mapper = (Mapper)in.readObject();
        this.combinerFactory = (CombinerFactory)in.readObject();
        this.reducerFactory = (ReducerFactory)in.readObject();
        this.keyValueSource = (KeyValueSource)in.readObject();
        this.chunkSize = in.readInt();
        int size = in.readInt();
        this.keys = new ArrayList(size);
        for (int i = 0; i < size; ++i) {
            this.keys.add(in.readObject());
        }
        if (in.readBoolean()) {
            this.topologyChangedStrategy = this.topologyChangedStrategyByOrdinal(in.readInt());
        }
    }

    private TopologyChangedStrategy topologyChangedStrategyByOrdinal(int ordinal) {
        for (TopologyChangedStrategy temp : TopologyChangedStrategy.values()) {
            if (ordinal != temp.ordinal()) continue;
            return temp;
        }
        throw new IllegalArgumentException("TopologyChangedStrategy with ordinal " + ordinal + " is unknown");
    }

    @Override
    public Permission getRequiredPermission() {
        return null;
    }
}

