/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.multimap.operations.client;

import com.hazelcast.client.RetryableRequest;
import com.hazelcast.multimap.operations.MultiMapOperationFactory;
import com.hazelcast.multimap.operations.client.MultiMapAllPartitionRequest;
import com.hazelcast.nio.IOUtil;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.nio.serialization.PortableReader;
import com.hazelcast.nio.serialization.PortableWriter;
import com.hazelcast.spi.OperationFactory;
import java.io.IOException;
import java.util.Map;

public class ContainsEntryRequest
extends MultiMapAllPartitionRequest
implements RetryableRequest {
    Data key;
    Data value;

    public ContainsEntryRequest() {
    }

    public ContainsEntryRequest(String name, Data key, Data value) {
        super(name);
        this.key = key;
        this.value = value;
    }

    @Override
    protected OperationFactory createOperationFactory() {
        return new MultiMapOperationFactory(this.name, MultiMapOperationFactory.OperationFactoryType.CONTAINS, this.key, this.value);
    }

    @Override
    protected Object reduce(Map<Integer, Object> map) {
        for (Object obj : map.values()) {
            if (!Boolean.TRUE.equals(obj)) continue;
            return true;
        }
        return false;
    }

    @Override
    public int getClassId() {
        return 2;
    }

    @Override
    public void write(PortableWriter writer) throws IOException {
        super.write(writer);
        ObjectDataOutput out = writer.getRawDataOutput();
        IOUtil.writeNullableData(out, this.key);
        IOUtil.writeNullableData(out, this.value);
    }

    @Override
    public void read(PortableReader reader) throws IOException {
        super.read(reader);
        ObjectDataInput in = reader.getRawDataInput();
        this.key = IOUtil.readNullableData(in);
        this.value = IOUtil.readNullableData(in);
    }

    @Override
    public String getMethodName() {
        if (this.key != null && this.value != null) {
            return "containsEntry";
        }
        if (this.key != null) {
            return "containsKey";
        }
        return "containsValue";
    }

    @Override
    public Object[] getParameters() {
        if (this.key != null && this.value != null) {
            return new Object[]{this.key, this.value};
        }
        if (this.key != null) {
            return new Object[]{this.key};
        }
        return new Object[]{this.value};
    }
}

