/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.nio.serialization;

import com.hazelcast.core.ManagedContext;
import com.hazelcast.nio.BufferObjectDataOutput;
import com.hazelcast.nio.serialization.BinaryClassDefinitionProxy;
import com.hazelcast.nio.serialization.ClassDefinition;
import com.hazelcast.nio.serialization.ClassDefinitionImpl;
import com.hazelcast.nio.serialization.ClassDefinitionWriter;
import com.hazelcast.nio.serialization.HazelcastSerializationException;
import com.hazelcast.nio.serialization.Portable;
import com.hazelcast.nio.serialization.PortableContext;
import com.hazelcast.nio.serialization.PortableVersionHelper;
import com.hazelcast.nio.serialization.SerializationServiceImpl;
import com.hazelcast.util.ByteUtil;
import com.hazelcast.util.ConcurrencyUtil;
import com.hazelcast.util.ConstructorFunction;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Collection;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.zip.DataFormatException;
import java.util.zip.Deflater;
import java.util.zip.Inflater;

final class PortableContextImpl
implements PortableContext {
    private static final int COMPRESSION_BUFFER_LENGTH = 1024;
    private final int version;
    private final ConcurrentHashMap<Integer, ClassDefinitionContext> classDefContextMap = new ConcurrentHashMap();
    private final SerializationServiceImpl serializationService;
    private final ConstructorFunction<Integer, ClassDefinitionContext> constructorFunction = new ConstructorFunction<Integer, ClassDefinitionContext>(){

        @Override
        public ClassDefinitionContext createNew(Integer arg) {
            return new ClassDefinitionContext();
        }
    };

    PortableContextImpl(SerializationServiceImpl serializationService, Collection<Integer> portableFactories, int version) {
        this.serializationService = serializationService;
        this.version = version;
        for (int factoryId : portableFactories) {
            this.classDefContextMap.put(factoryId, new ClassDefinitionContext());
        }
    }

    @Override
    public int getClassVersion(int factoryId, int classId) {
        return this.getClassDefContext(factoryId).getClassVersion(classId);
    }

    @Override
    public void setClassVersion(int factoryId, int classId, int version) {
        this.getClassDefContext(factoryId).setClassVersion(classId, version);
    }

    @Override
    public ClassDefinition lookup(int factoryId, int classId, int version) {
        return this.getClassDefContext(factoryId).lookup(classId, version);
    }

    @Override
    public ClassDefinition createClassDefinition(int factoryId, byte[] compressedBinary) throws IOException {
        return this.getClassDefContext(factoryId).create(compressedBinary);
    }

    @Override
    public ClassDefinition registerClassDefinition(ClassDefinition cd) {
        return this.getClassDefContext(cd.getFactoryId()).register(cd);
    }

    @Override
    public ClassDefinition lookupOrRegisterClassDefinition(Portable p) throws IOException {
        int portableVersion = PortableVersionHelper.getVersion(p, this.version);
        ClassDefinition cd = this.lookup(p.getFactoryId(), p.getClassId(), portableVersion);
        if (cd == null) {
            ClassDefinitionWriter classDefinitionWriter = new ClassDefinitionWriter(this, p.getFactoryId(), p.getClassId(), portableVersion);
            p.writePortable(classDefinitionWriter);
            cd = classDefinitionWriter.registerAndGet();
        }
        return cd;
    }

    private void registerNestedDefinitions(ClassDefinitionImpl cd) {
        Set<ClassDefinition> nestedDefinitions = cd.getNestedClassDefinitions();
        for (ClassDefinition classDefinition : nestedDefinitions) {
            ClassDefinitionImpl nestedCD = (ClassDefinitionImpl)classDefinition;
            this.registerClassDefinition(nestedCD);
        }
    }

    private ClassDefinitionContext getClassDefContext(int factoryId) {
        return ConcurrencyUtil.getOrPutIfAbsent(this.classDefContextMap, factoryId, this.constructorFunction);
    }

    @Override
    public int getVersion() {
        return this.version;
    }

    @Override
    public ManagedContext getManagedContext() {
        return this.serializationService.getManagedContext();
    }

    static void compress(byte[] input, DataOutput out) throws IOException {
        Deflater deflater = new Deflater();
        deflater.setLevel(-1);
        deflater.setStrategy(1);
        deflater.setInput(input);
        deflater.finish();
        byte[] buf = new byte[1024];
        while (!deflater.finished()) {
            int count = deflater.deflate(buf);
            out.write(buf, 0, count);
        }
        deflater.end();
    }

    static void decompress(byte[] compressedData, DataOutput out) throws IOException {
        Inflater inflater = new Inflater();
        inflater.setInput(compressedData);
        byte[] buf = new byte[1024];
        while (!inflater.finished()) {
            try {
                int count = inflater.inflate(buf);
                out.write(buf, 0, count);
            }
            catch (DataFormatException e) {
                throw new IOException(e);
            }
        }
        inflater.end();
    }

    private class ClassDefinitionContext {
        final ConcurrentMap<Long, ClassDefinition> versionedDefinitions = new ConcurrentHashMap<Long, ClassDefinition>();
        final ConcurrentMap<Integer, Integer> currentClassVersions = new ConcurrentHashMap<Integer, Integer>();

        private ClassDefinitionContext() {
        }

        int getClassVersion(int classId) {
            Integer version = (Integer)this.currentClassVersions.get(classId);
            return version != null ? version : -1;
        }

        void setClassVersion(int classId, int version) {
            Integer current = this.currentClassVersions.putIfAbsent(classId, version);
            if (current != null && current != version) {
                throw new IllegalArgumentException("Class-id: " + classId + " is already registered!");
            }
        }

        ClassDefinition lookup(int classId, int version) {
            long versionedClassId = ByteUtil.combineToLong(classId, version);
            ClassDefinition cd = (ClassDefinition)this.versionedDefinitions.get(versionedClassId);
            if (cd instanceof BinaryClassDefinitionProxy) {
                try {
                    cd = this.create(((BinaryClassDefinitionProxy)cd).getBinary());
                }
                catch (IOException e) {
                    throw new HazelcastSerializationException(e);
                }
            }
            return cd;
        }

        ClassDefinition create(byte[] compressedBinary) throws IOException {
            if (compressedBinary == null || compressedBinary.length == 0) {
                throw new IOException("Illegal class-definition binary! ");
            }
            byte[] binary = this.getClassDefBinary(compressedBinary);
            ClassDefinitionImpl cd = new ClassDefinitionImpl();
            cd.readData(PortableContextImpl.this.serializationService.createObjectDataInput(binary));
            if (cd.getVersion() < 0) {
                throw new IOException("ClassDefinition version cannot be negative! -> " + cd);
            }
            cd.setBinary(compressedBinary);
            return this.register(cd);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private byte[] getClassDefBinary(byte[] compressedBinary) throws IOException {
            byte[] binary;
            BufferObjectDataOutput out = PortableContextImpl.this.serializationService.pop();
            try {
                PortableContextImpl.decompress(compressedBinary, out);
                binary = out.toByteArray();
            }
            finally {
                PortableContextImpl.this.serializationService.push(out);
            }
            return binary;
        }

        ClassDefinition register(ClassDefinition cd) {
            long versionedClassId;
            ClassDefinition currentCd;
            if (cd == null) {
                return null;
            }
            if (cd instanceof ClassDefinitionImpl) {
                ClassDefinitionImpl cdImpl = (ClassDefinitionImpl)cd;
                if (cdImpl.getVersion() < 0) {
                    cdImpl.version = PortableContextImpl.this.getVersion();
                }
                this.setClassDefBinary(cdImpl);
                PortableContextImpl.this.registerNestedDefinitions(cdImpl);
            }
            if ((currentCd = this.versionedDefinitions.putIfAbsent(versionedClassId = ByteUtil.combineToLong(cd.getClassId(), cd.getVersion()), cd)) == null) {
                return cd;
            }
            if (currentCd instanceof ClassDefinitionImpl) {
                return currentCd;
            }
            this.versionedDefinitions.put(versionedClassId, cd);
            return cd;
        }

        private void setClassDefBinary(ClassDefinitionImpl cd) {
            if (cd.getBinary() == null) {
                BufferObjectDataOutput out = PortableContextImpl.this.serializationService.pop();
                try {
                    cd.writeData(out);
                    byte[] binary = out.toByteArray();
                    out.clear();
                    PortableContextImpl.compress(binary, out);
                    cd.setBinary(out.toByteArray());
                }
                catch (IOException e) {
                    throw new HazelcastSerializationException(e);
                }
                finally {
                    PortableContextImpl.this.serializationService.push(out);
                }
            }
        }
    }
}

