/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.queue;

import com.hazelcast.core.ItemEventType;
import com.hazelcast.monitor.impl.LocalQueueStatsImpl;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.queue.DrainBackupOperation;
import com.hazelcast.queue.QueueBackupAwareOperation;
import com.hazelcast.queue.QueueContainer;
import com.hazelcast.spi.Notifier;
import com.hazelcast.spi.Operation;
import com.hazelcast.spi.WaitNotifyKey;
import com.hazelcast.spi.impl.SerializableCollection;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;

public class DrainOperation
extends QueueBackupAwareOperation
implements Notifier {
    private int maxSize;
    private Map<Long, Data> dataMap;

    public DrainOperation() {
    }

    public DrainOperation(String name, int maxSize) {
        super(name);
        this.maxSize = maxSize;
    }

    @Override
    public void run() throws Exception {
        QueueContainer container = this.getOrCreateContainer();
        this.dataMap = container.drain(this.maxSize);
        this.response = new SerializableCollection(new ArrayList<Data>(this.dataMap.values()));
    }

    @Override
    public void afterRun() throws Exception {
        LocalQueueStatsImpl localQueueStatsImpl = this.getQueueService().getLocalQueueStatsImpl(this.name);
        localQueueStatsImpl.incrementOtherOperations();
        for (Data data : this.dataMap.values()) {
            this.publishEvent(ItemEventType.REMOVED, data);
        }
    }

    @Override
    public boolean shouldBackup() {
        return this.dataMap.size() > 0;
    }

    @Override
    public Operation getBackupOperation() {
        return new DrainBackupOperation(this.name, this.dataMap.keySet());
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        super.writeInternal(out);
        out.writeInt(this.maxSize);
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        super.readInternal(in);
        this.maxSize = in.readInt();
    }

    @Override
    public boolean shouldNotify() {
        return this.dataMap.size() > 0;
    }

    @Override
    public WaitNotifyKey getNotifiedKey() {
        return this.getOrCreateContainer().getOfferWaitNotifyKey();
    }

    @Override
    public int getId() {
        return 13;
    }
}

