/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.replicatedmap.messages;

import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import com.hazelcast.replicatedmap.messages.ReplicationMessage;
import com.hazelcast.replicatedmap.operation.ReplicatedMapDataSerializerHook;
import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.io.IOException;

public class MultiReplicationMessage
implements IdentifiedDataSerializable {
    private String name;
    private ReplicationMessage[] replicationMessages;

    public MultiReplicationMessage() {
    }

    @SuppressWarnings(value={"EI_EXPOSE_REP"})
    public MultiReplicationMessage(String name, ReplicationMessage[] replicationMessages) {
        this.name = name;
        this.replicationMessages = replicationMessages;
    }

    @SuppressWarnings(value={"EI_EXPOSE_REP"})
    public ReplicationMessage[] getReplicationMessages() {
        return this.replicationMessages;
    }

    public String getName() {
        return this.name;
    }

    @Override
    public void writeData(ObjectDataOutput out) throws IOException {
        out.writeUTF(this.name);
        out.writeInt(this.replicationMessages.length);
        for (int i = 0; i < this.replicationMessages.length; ++i) {
            this.replicationMessages[i].writeData(out);
        }
    }

    @Override
    public void readData(ObjectDataInput in) throws IOException {
        this.name = in.readUTF();
        int length = in.readInt();
        this.replicationMessages = new ReplicationMessage[length];
        for (int i = 0; i < length; ++i) {
            ReplicationMessage replicationMessage = new ReplicationMessage();
            replicationMessage.readData(in);
            this.replicationMessages[i] = replicationMessage;
        }
    }

    @Override
    public int getFactoryId() {
        return ReplicatedMapDataSerializerHook.F_ID;
    }

    @Override
    public int getId() {
        return 4;
    }
}

