/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.replicatedmap.operation;

import com.hazelcast.core.Member;
import com.hazelcast.instance.MemberImpl;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.DataSerializable;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import com.hazelcast.replicatedmap.ReplicatedMapService;
import com.hazelcast.replicatedmap.operation.AbstractReplicatedMapOperation;
import com.hazelcast.replicatedmap.operation.ReplicatedMapDataSerializerHook;
import com.hazelcast.replicatedmap.operation.ReplicatedMapInitChunkOperation;
import com.hazelcast.replicatedmap.record.AbstractReplicatedRecordStore;
import com.hazelcast.replicatedmap.record.ReplicationPublisher;
import com.hazelcast.spi.OperationService;
import java.io.IOException;
import java.util.Arrays;

public class ReplicatedMapPostJoinOperation
extends AbstractReplicatedMapOperation
implements IdentifiedDataSerializable {
    public static final int DEFAULT_CHUNK_SIZE = 100;
    private MemberMapPair[] replicatedMaps;
    private int chunkSize;

    ReplicatedMapPostJoinOperation() {
    }

    public ReplicatedMapPostJoinOperation(MemberMapPair[] replicatedMaps, int chunkSize) {
        this.replicatedMaps = Arrays.copyOf(replicatedMaps, replicatedMaps.length);
        this.chunkSize = chunkSize;
    }

    @Override
    public void run() throws Exception {
        MemberImpl localMember = this.getNodeEngine().getLocalMember();
        ReplicatedMapService replicatedMapService = (ReplicatedMapService)this.getService();
        for (MemberMapPair replicatedMap : this.replicatedMaps) {
            String mapName = replicatedMap.getName();
            if (!((Object)localMember).equals(replicatedMap.getMember())) continue;
            AbstractReplicatedRecordStore recordStorage = (AbstractReplicatedRecordStore)replicatedMapService.getReplicatedRecordStore(mapName, false);
            if (recordStorage != null && recordStorage.isLoaded()) {
                ReplicationPublisher replicationPublisher = recordStorage.getReplicationPublisher();
                replicationPublisher.queuePreProvision(this.getCallerAddress(), this.chunkSize);
                continue;
            }
            OperationService operationService = this.getNodeEngine().getOperationService();
            ReplicatedMapInitChunkOperation operation = new ReplicatedMapInitChunkOperation(mapName, localMember);
            operationService.send(operation, this.getCallerAddress());
        }
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        out.writeInt(this.chunkSize);
        out.writeInt(this.replicatedMaps.length);
        for (int i = 0; i < this.replicatedMaps.length; ++i) {
            this.replicatedMaps[i].writeData(out);
        }
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        this.chunkSize = in.readInt();
        int length = in.readInt();
        this.replicatedMaps = new MemberMapPair[length];
        for (int i = 0; i < length; ++i) {
            this.replicatedMaps[i] = new MemberMapPair();
            this.replicatedMaps[i].readData(in);
        }
    }

    @Override
    public int getFactoryId() {
        return ReplicatedMapDataSerializerHook.F_ID;
    }

    @Override
    public int getId() {
        return 6;
    }

    public static class MemberMapPair
    implements DataSerializable {
        private Member member;
        private String name;

        MemberMapPair() {
        }

        public MemberMapPair(Member member, String name) {
            this.member = member;
            this.name = name;
        }

        public Member getMember() {
            return this.member;
        }

        public String getName() {
            return this.name;
        }

        @Override
        public void writeData(ObjectDataOutput out) throws IOException {
            out.writeUTF(this.name);
            this.member.writeData(out);
        }

        @Override
        public void readData(ObjectDataInput in) throws IOException {
            this.name = in.readUTF();
            this.member = new MemberImpl();
            this.member.readData(in);
        }
    }
}

