/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.management.request;

import com.hazelcast.com.eclipsesource.json.JsonArray;
import com.hazelcast.com.eclipsesource.json.JsonObject;
import com.hazelcast.com.eclipsesource.json.JsonValue;
import com.hazelcast.instance.Node;
import com.hazelcast.logging.SystemLogRecord;
import com.hazelcast.logging.SystemLogService;
import com.hazelcast.management.ManagementCenterService;
import com.hazelcast.management.request.ConsoleRequest;
import com.hazelcast.nio.Address;
import com.hazelcast.util.JsonUtil;
import java.util.LinkedList;
import java.util.List;

public class GetLogsRequest
implements ConsoleRequest {
    @Override
    public int getType() {
        return 11;
    }

    @Override
    public Object readResponse(JsonObject json) {
        LinkedList<SystemLogRecord> list = new LinkedList<SystemLogRecord>();
        String node = JsonUtil.getString(json, "node", "");
        JsonArray logs = JsonUtil.getArray(json, "logs", new JsonArray());
        for (JsonValue log : logs) {
            SystemLogRecord systemLogRecord = new SystemLogRecord();
            systemLogRecord.fromJson(log.asObject());
            systemLogRecord.setNode(node);
            list.add(systemLogRecord);
        }
        return list;
    }

    @Override
    public void writeResponse(ManagementCenterService mcs, JsonObject root) throws Exception {
        JsonObject result = new JsonObject();
        Node node = mcs.getHazelcastInstance().node;
        SystemLogService systemLogService = node.getSystemLogService();
        List<SystemLogRecord> logBundle = systemLogService.getLogBundle();
        Address address = node.getThisAddress();
        result.add("node", address.getHost() + ":" + address.getPort());
        JsonArray logs = new JsonArray();
        for (SystemLogRecord systemLogRecord : logBundle) {
            logs.add(systemLogRecord.toJson());
        }
        result.add("logs", logs);
        root.add("result", result);
    }

    @Override
    public JsonObject toJson() {
        return new JsonObject();
    }

    @Override
    public void fromJson(JsonObject json) {
    }
}

