/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.mapstore.writebehind;

import com.hazelcast.map.MapStoreWrapper;
import com.hazelcast.map.mapstore.AbstractMapDataStore;
import com.hazelcast.map.mapstore.writebehind.DelayedEntry;
import com.hazelcast.map.mapstore.writebehind.WriteBehindProcessor;
import com.hazelcast.map.mapstore.writebehind.WriteBehindQueue;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.nio.serialization.SerializationService;
import com.hazelcast.util.Clock;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class WriteBehindStore
extends AbstractMapDataStore<Data, Object> {
    private final long writeDelayTime;
    private final int partitionId;
    private WriteBehindQueue<DelayedEntry> writeBehindQueue;
    private WriteBehindProcessor writeBehindProcessor;
    private final Map<Data, DelayedEntry> stagingArea;
    private final Set<Data> writeBehindWaitingDeletions = new HashSet<Data>();
    private Iterator<DelayedEntry> stagingAreaIterator;
    private long lastCleanupTime;
    private final boolean writeCoalescing;

    public WriteBehindStore(MapStoreWrapper store, SerializationService serializationService, long writeDelayTime, int partitionId, boolean writeCoalescing) {
        super(store, serializationService);
        this.writeDelayTime = writeDelayTime;
        this.partitionId = partitionId;
        this.stagingArea = this.createStagingArea();
        this.writeCoalescing = writeCoalescing;
    }

    public void setWriteBehindQueue(WriteBehindQueue<DelayedEntry> writeBehindQueue) {
        this.writeBehindQueue = writeBehindQueue;
    }

    @Override
    public Object add(Data key, Object value, long now) {
        this.cleanupStagingArea(now);
        long writeDelay = this.writeDelayTime;
        long storeTime = now + writeDelay;
        DelayedEntry<Data, Object> delayedEntry = DelayedEntry.create(key, value, storeTime, this.partitionId);
        this.writeBehindQueue.offer(delayedEntry);
        this.removeFromWaitingDeletions(key);
        return value;
    }

    @Override
    public void addTransient(Data key, long now) {
        this.cleanupStagingArea(now);
        this.removeFromWaitingDeletions(key);
    }

    @Override
    public Object addBackup(Data key, Object value, long time) {
        return this.add(key, value, time);
    }

    @Override
    public void remove(Data key, long now) {
        this.cleanupStagingArea(now);
        long writeDelay = this.writeDelayTime;
        long storeTime = now + writeDelay;
        DelayedEntry delayedEntry = DelayedEntry.createWithNullValue(key, storeTime, this.partitionId);
        this.addToWaitingDeletions(key);
        this.removeFromStagingArea(key);
        this.writeBehindQueue.offer(delayedEntry);
    }

    @Override
    public void removeBackup(Data key, long time) {
        this.remove(key, time);
    }

    @Override
    public void reset() {
        this.writeBehindQueue.clear();
        this.writeBehindWaitingDeletions.clear();
        this.stagingArea.clear();
    }

    @Override
    public Object load(Data key) {
        if (this.hasWaitingWriteBehindDeleteOperation(key)) {
            return null;
        }
        Object valueFromStagingArea = this.getFromStagingArea(key);
        return valueFromStagingArea == null ? this.getStore().load(this.toObject(key)) : valueFromStagingArea;
    }

    @Override
    public Map loadAll(Collection keys) {
        if (keys == null || keys.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap<Data, Object> map = new HashMap<Data, Object>();
        Iterator iterator = keys.iterator();
        while (iterator.hasNext()) {
            Object key = iterator.next();
            Data dataKey = this.toData(key);
            if (this.hasWaitingWriteBehindDeleteOperation(dataKey)) {
                iterator.remove();
                continue;
            }
            Object valueFromStagingArea = this.getFromStagingArea(dataKey);
            if (valueFromStagingArea == null) continue;
            map.put(dataKey, valueFromStagingArea);
            iterator.remove();
        }
        map.putAll(super.loadAll(keys));
        return map;
    }

    @Override
    public boolean loadable(Data key, long lastUpdateTime, long now) {
        return !this.hasWaitingWriteBehindDeleteOperation(key) && !this.isInStagingArea(key, now) && !this.hasAnyWaitingOperationInWriteBehindQueue(lastUpdateTime, now);
    }

    @Override
    public int notFinishedOperationsCount() {
        return this.writeBehindQueue.size();
    }

    @Override
    public Object flush(Data key, Object value, long now) {
        if (this.writeCoalescing) {
            return this.defaultFlush(key);
        }
        return this.flushWhenNotWriteCoalescing(key, value, now);
    }

    @Override
    public Collection flush() {
        return this.writeBehindProcessor.flush(this.writeBehindQueue);
    }

    private void addToWaitingDeletions(Data key) {
        this.writeBehindWaitingDeletions.add(key);
    }

    private void removeFromWaitingDeletions(Data key) {
        this.writeBehindWaitingDeletions.remove(key);
    }

    private void removeFromStagingArea(Data key) {
        this.stagingArea.remove(key);
    }

    private boolean hasWaitingWriteBehindDeleteOperation(Data key) {
        return this.writeBehindWaitingDeletions.contains(key);
    }

    private boolean hasAnyWaitingOperationInWriteBehindQueue(long lastUpdateTime, long now) {
        long scheduledStoreTime = lastUpdateTime + this.writeDelayTime;
        return now < scheduledStoreTime;
    }

    private Map<Data, DelayedEntry> createStagingArea() {
        return new ConcurrentHashMap<Data, DelayedEntry>();
    }

    private void initStagingAreaIterator() {
        if (this.stagingAreaIterator == null || !this.stagingAreaIterator.hasNext()) {
            this.stagingAreaIterator = this.stagingArea.values().iterator();
        }
    }

    public void cleanupStagingArea(long now) {
        if (this.stagingArea.isEmpty() || !this.inEvictableTimeWindow(now)) {
            return;
        }
        int size = this.stagingArea.size();
        if (size == 0) {
            return;
        }
        long nextItemsStoreTimeInWriteBehindQueue = this.getNextItemsStoreTimeInWriteBehindQueue();
        int evictionPercentage = 20;
        int maxAllowedIterationCount = this.getMaxIterationCount(size, 20);
        this.initStagingAreaIterator();
        while (this.stagingAreaIterator.hasNext() && maxAllowedIterationCount > 0) {
            --maxAllowedIterationCount;
            DelayedEntry entry = this.stagingAreaIterator.next();
            if (entry.getStoreTime() < nextItemsStoreTimeInWriteBehindQueue) {
                this.stagingAreaIterator.remove();
            }
            this.initStagingAreaIterator();
            if (!this.stagingAreaIterator.hasNext()) break;
            this.lastCleanupTime = now;
        }
    }

    private long getNextItemsStoreTimeInWriteBehindQueue() {
        DelayedEntry firstEntryInQueue = this.writeBehindQueue.getFirst();
        if (firstEntryInQueue == null) {
            return 0L;
        }
        return firstEntryInQueue.getStoreTime();
    }

    private int getMaxIterationCount(int size, int percentage) {
        int defaultMaxIterationCount = 100;
        float oneHundred = 100.0f;
        float maxIterationCount = (float)size * ((float)percentage / 100.0f);
        if (maxIterationCount <= 100.0f) {
            return 100;
        }
        return Math.round(maxIterationCount);
    }

    private boolean inEvictableTimeWindow(long now) {
        int evictAfterMs = 1000;
        return now - this.lastCleanupTime > 1000L;
    }

    private boolean isInStagingArea(Data key, long now) {
        DelayedEntry entry = this.stagingArea.get(key);
        if (entry == null) {
            return false;
        }
        long storeTime = entry.getStoreTime();
        return now < storeTime;
    }

    private Object getFromStagingArea(Data key) {
        DelayedEntry entry = this.stagingArea.get(key);
        if (entry == null) {
            return null;
        }
        long storeTime = entry.getStoreTime();
        long now = Clock.currentTimeMillis();
        if (now >= storeTime) {
            return null;
        }
        return this.toObject(entry.getValue());
    }

    private Object defaultFlush(Data key) {
        DelayedEntry entry = DelayedEntry.createWithNullValue(key, -1L, -1);
        if ((entry = this.writeBehindQueue.get(entry)) == null) {
            return null;
        }
        this.writeBehindProcessor.flush(entry);
        List entries = Collections.singletonList(entry);
        this.writeBehindQueue.removeAll(entries);
        return entry.getValue();
    }

    private Object flushWhenNotWriteCoalescing(Data key, Object value, long now) {
        assert (value != null) : String.format("value is null", new Object[0]);
        assert (now > 0L) : String.format("time should be greater than 0, but found %d", now);
        this.cleanupStagingArea(now);
        long storeTime = now + this.writeDelayTime;
        DelayedEntry delayedEntry = DelayedEntry.createWithNullKey(value, storeTime);
        this.stagingArea.put(key, delayedEntry);
        this.removeFromWaitingDeletions(key);
        return value;
    }

    public WriteBehindQueue<DelayedEntry> getWriteBehindQueue() {
        return this.writeBehindQueue;
    }

    public void setWriteBehindProcessor(WriteBehindProcessor writeBehindProcessor) {
        this.writeBehindProcessor = writeBehindProcessor;
    }
}

