/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.instance;

import com.hazelcast.ascii.TextCommandService;
import com.hazelcast.ascii.TextCommandServiceImpl;
import com.hazelcast.client.impl.ClientEngineImpl;
import com.hazelcast.cluster.ClusterServiceImpl;
import com.hazelcast.cluster.ConfigCheck;
import com.hazelcast.cluster.JoinRequest;
import com.hazelcast.cluster.Joiner;
import com.hazelcast.cluster.MulticastJoiner;
import com.hazelcast.cluster.MulticastService;
import com.hazelcast.cluster.NodeMulticastListener;
import com.hazelcast.cluster.TcpIpJoiner;
import com.hazelcast.config.Config;
import com.hazelcast.config.JoinConfig;
import com.hazelcast.config.ListenerConfig;
import com.hazelcast.config.MemberAttributeConfig;
import com.hazelcast.config.MulticastConfig;
import com.hazelcast.config.SerializationConfig;
import com.hazelcast.core.DistributedObjectListener;
import com.hazelcast.core.HazelcastInstanceAware;
import com.hazelcast.core.LifecycleListener;
import com.hazelcast.core.MembershipListener;
import com.hazelcast.core.MigrationListener;
import com.hazelcast.core.PartitioningStrategy;
import com.hazelcast.instance.AddressPicker;
import com.hazelcast.instance.BuildInfo;
import com.hazelcast.instance.BuildInfoProvider;
import com.hazelcast.instance.GroupProperties;
import com.hazelcast.instance.HazelcastInstanceImpl;
import com.hazelcast.instance.MemberImpl;
import com.hazelcast.instance.NodeContext;
import com.hazelcast.instance.NodeInitializer;
import com.hazelcast.instance.NodeInitializerFactory;
import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.LoggingServiceImpl;
import com.hazelcast.management.ManagementCenterService;
import com.hazelcast.nio.Address;
import com.hazelcast.nio.ClassLoaderUtil;
import com.hazelcast.nio.ConnectionManager;
import com.hazelcast.nio.serialization.SerializationService;
import com.hazelcast.nio.serialization.SerializationServiceBuilder;
import com.hazelcast.nio.serialization.SerializationServiceImpl;
import com.hazelcast.partition.InternalPartitionService;
import com.hazelcast.partition.impl.InternalPartitionServiceImpl;
import com.hazelcast.partition.strategy.DefaultPartitioningStrategy;
import com.hazelcast.security.Credentials;
import com.hazelcast.security.SecurityContext;
import com.hazelcast.spi.impl.NodeEngineImpl;
import com.hazelcast.spi.impl.ProxyServiceImpl;
import com.hazelcast.util.Clock;
import com.hazelcast.util.ExceptionUtil;
import com.hazelcast.util.UuidUtil;
import com.hazelcast.util.VersionCheck;
import java.lang.reflect.Constructor;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.MulticastSocket;
import java.nio.channels.ServerSocketChannel;
import java.util.EventListener;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;

public class Node {
    private final ILogger logger;
    private final AtomicBoolean joined = new AtomicBoolean(false);
    private volatile boolean active;
    private volatile boolean completelyShutdown;
    private final NodeShutdownHookThread shutdownHookThread = new NodeShutdownHookThread("hz.ShutdownThread");
    private final SerializationServiceImpl serializationService;
    public final NodeEngineImpl nodeEngine;
    public final ClientEngineImpl clientEngine;
    public final InternalPartitionService partitionService;
    public final ClusterServiceImpl clusterService;
    public final MulticastService multicastService;
    public final ConnectionManager connectionManager;
    public final TextCommandServiceImpl textCommandService;
    public final Config config;
    public final GroupProperties groupProperties;
    public final Address address;
    public final MemberImpl localMember;
    private volatile Address masterAddress = null;
    public final HazelcastInstanceImpl hazelcastInstance;
    public final LoggingServiceImpl loggingService;
    private final Joiner joiner;
    public final NodeInitializer initializer;
    private ManagementCenterService managementCenterService;
    public final SecurityContext securityContext;
    public final ThreadGroup threadGroup;
    private final ClassLoader configClassLoader;
    private final BuildInfo buildInfo;
    private final VersionCheck versionCheck = new VersionCheck();

    public Node(HazelcastInstanceImpl hazelcastInstance, Config config, NodeContext nodeContext) {
        this.hazelcastInstance = hazelcastInstance;
        this.threadGroup = hazelcastInstance.threadGroup;
        this.config = config;
        this.configClassLoader = config.getClassLoader();
        this.groupProperties = new GroupProperties(config);
        this.buildInfo = BuildInfoProvider.getBuildInfo();
        this.serializationService = (SerializationServiceImpl)this.createSerializationService(hazelcastInstance, config);
        String loggingType = this.groupProperties.LOGGING_TYPE.getString();
        this.loggingService = new LoggingServiceImpl(config.getGroupConfig().getName(), loggingType, this.buildInfo);
        AddressPicker addressPicker = nodeContext.createAddressPicker(this);
        try {
            addressPicker.pickAddress();
        }
        catch (Throwable e) {
            throw ExceptionUtil.rethrow(e);
        }
        ServerSocketChannel serverSocketChannel = addressPicker.getServerSocketChannel();
        try {
            this.address = addressPicker.getPublicAddress();
            Map<String, Object> memberAttributes = this.findMemberAttributes(config.getMemberAttributeConfig().asReadOnly());
            this.localMember = new MemberImpl(this.address, true, UuidUtil.createMemberUuid(this.address), hazelcastInstance, memberAttributes);
            this.loggingService.setThisMember(this.localMember);
            this.logger = this.loggingService.getLogger(Node.class.getName());
            this.initializer = NodeInitializerFactory.create(this.configClassLoader);
            this.initializer.beforeInitialize(this);
            this.securityContext = config.getSecurityConfig().isEnabled() ? this.initializer.getSecurityContext() : null;
            this.nodeEngine = new NodeEngineImpl(this);
            this.clientEngine = new ClientEngineImpl(this);
            this.connectionManager = nodeContext.createConnectionManager(this, serverSocketChannel);
            this.partitionService = new InternalPartitionServiceImpl(this);
            this.clusterService = new ClusterServiceImpl(this);
            this.textCommandService = new TextCommandServiceImpl(this);
            this.initializer.printNodeInfo(this);
            this.versionCheck.check(this, this.getBuildInfo().getVersion(), this.buildInfo.isEnterprise());
            this.multicastService = this.createMulticastService(addressPicker);
            this.initializeListeners(config);
            this.joiner = nodeContext.createJoiner(this);
        }
        catch (Throwable e) {
            try {
                serverSocketChannel.close();
            }
            catch (Throwable ignored) {
                // empty catch block
            }
            throw ExceptionUtil.rethrow(e);
        }
    }

    private SerializationService createSerializationService(HazelcastInstanceImpl hazelcastInstance, Config config) {
        SerializationService ss;
        try {
            String partitioningStrategyClassName = this.groupProperties.PARTITIONING_STRATEGY_CLASS.getString();
            PartitioningStrategy partitioningStrategy = partitioningStrategyClassName != null && partitioningStrategyClassName.length() > 0 ? (PartitioningStrategy)ClassLoaderUtil.newInstance(this.configClassLoader, partitioningStrategyClassName) : new DefaultPartitioningStrategy();
            ss = new SerializationServiceBuilder().setClassLoader(this.configClassLoader).setConfig(config.getSerializationConfig() != null ? config.getSerializationConfig() : new SerializationConfig()).setManagedContext(hazelcastInstance.managedContext).setPartitioningStrategy(partitioningStrategy).setHazelcastInstance(hazelcastInstance).build();
        }
        catch (Exception e) {
            throw ExceptionUtil.rethrow(e);
        }
        return ss;
    }

    private MulticastService createMulticastService(AddressPicker addressPicker) {
        MulticastService mcService;
        block6: {
            mcService = null;
            try {
                JoinConfig join = this.config.getNetworkConfig().getJoin();
                if (!join.getMulticastConfig().isEnabled()) break block6;
                MulticastConfig multicastConfig = join.getMulticastConfig();
                MulticastSocket multicastSocket = new MulticastSocket(null);
                multicastSocket.setReuseAddress(true);
                multicastSocket.bind(new InetSocketAddress(multicastConfig.getMulticastPort()));
                multicastSocket.setTimeToLive(multicastConfig.getMulticastTimeToLive());
                try {
                    Address bindAddress = addressPicker.getBindAddress();
                    if (!bindAddress.getInetAddress().isLoopbackAddress()) {
                        multicastSocket.setInterface(bindAddress.getInetAddress());
                    }
                }
                catch (Exception e) {
                    this.logger.warning(e);
                }
                multicastSocket.setReceiveBufferSize(65536);
                multicastSocket.setSendBufferSize(65536);
                String multicastGroup = System.getProperty("hazelcast.multicast.group");
                if (multicastGroup == null) {
                    multicastGroup = multicastConfig.getMulticastGroup();
                }
                multicastConfig.setMulticastGroup(multicastGroup);
                multicastSocket.joinGroup(InetAddress.getByName(multicastGroup));
                multicastSocket.setSoTimeout(1000);
                mcService = new MulticastService(this, multicastSocket);
                mcService.addMulticastListener(new NodeMulticastListener(this));
            }
            catch (Exception e) {
                this.logger.severe(e);
            }
        }
        return mcService;
    }

    private void initializeListeners(Config config) {
        for (ListenerConfig listenerCfg : config.getListenerConfigs()) {
            EventListener listener = listenerCfg.getImplementation();
            if (listener == null) {
                try {
                    listener = ClassLoaderUtil.newInstance(this.configClassLoader, listenerCfg.getClassName());
                }
                catch (Exception e) {
                    this.logger.severe(e);
                }
            }
            if (listener instanceof HazelcastInstanceAware) {
                ((HazelcastInstanceAware)((Object)listener)).setHazelcastInstance(this.hazelcastInstance);
            }
            boolean known = false;
            if (listener instanceof DistributedObjectListener) {
                ProxyServiceImpl proxyService = (ProxyServiceImpl)this.nodeEngine.getProxyService();
                proxyService.addProxyListener((DistributedObjectListener)listener);
                known = true;
            }
            if (listener instanceof MembershipListener) {
                this.clusterService.addMembershipListener((MembershipListener)listener);
                known = true;
            }
            if (listener instanceof MigrationListener) {
                this.partitionService.addMigrationListener((MigrationListener)listener);
                known = true;
            }
            if (listener instanceof LifecycleListener) {
                this.hazelcastInstance.lifecycleService.addLifecycleListener((LifecycleListener)listener);
                known = true;
            }
            if (listener == null || known) continue;
            String error = "Unknown listener type: " + listener.getClass();
            IllegalArgumentException t = new IllegalArgumentException(error);
            this.logger.warning(error, t);
        }
    }

    public ManagementCenterService getManagementCenterService() {
        return this.managementCenterService;
    }

    public SerializationService getSerializationService() {
        return this.serializationService;
    }

    public ClusterServiceImpl getClusterService() {
        return this.clusterService;
    }

    public InternalPartitionService getPartitionService() {
        return this.partitionService;
    }

    public Address getMasterAddress() {
        return this.masterAddress;
    }

    public Address getThisAddress() {
        return this.address;
    }

    public MemberImpl getLocalMember() {
        return this.localMember;
    }

    public String getName() {
        return this.hazelcastInstance.getName();
    }

    public String getThreadNamePrefix(String name) {
        return "hz." + this.getName() + "." + name;
    }

    public String getThreadPoolNamePrefix(String poolName) {
        return this.getThreadNamePrefix(poolName) + ".thread-";
    }

    public boolean joined() {
        return this.joined.get();
    }

    public boolean isMaster() {
        return this.address != null && this.address.equals(this.masterAddress);
    }

    public void setMasterAddress(Address master) {
        if (master != null && this.logger.isFinestEnabled()) {
            this.logger.finest("** setting master address to " + master);
        }
        this.masterAddress = master;
    }

    public void start() {
        if (this.logger.isFinestEnabled()) {
            this.logger.finest("We are asked to start and completelyShutdown is " + String.valueOf(this.completelyShutdown));
        }
        if (this.completelyShutdown) {
            return;
        }
        this.nodeEngine.start();
        this.connectionManager.start();
        if (this.config.getNetworkConfig().getJoin().getMulticastConfig().isEnabled()) {
            Thread multicastServiceThread = new Thread(this.hazelcastInstance.threadGroup, this.multicastService, this.getThreadNamePrefix("MulticastThread"));
            multicastServiceThread.start();
        }
        this.setActive(true);
        if (!this.completelyShutdown) {
            this.logger.finest("Adding ShutdownHook");
            Runtime.getRuntime().addShutdownHook(this.shutdownHookThread);
        }
        this.logger.finest("finished starting threads, calling join");
        this.join();
        int clusterSize = this.clusterService.getSize();
        if (this.config.getNetworkConfig().isPortAutoIncrement() && this.address.getPort() >= this.config.getNetworkConfig().getPort() + clusterSize) {
            StringBuilder sb = new StringBuilder("Config seed port is ");
            sb.append(this.config.getNetworkConfig().getPort());
            sb.append(" and cluster size is ");
            sb.append(clusterSize);
            sb.append(". Some of the ports seem occupied!");
            this.logger.warning(sb.toString());
        }
        try {
            this.managementCenterService = new ManagementCenterService(this.hazelcastInstance);
        }
        catch (Exception e) {
            this.logger.warning("ManagementCenterService could not be constructed!", e);
        }
        this.initializer.afterInitialize(this);
    }

    public void shutdown(boolean terminate) {
        int maxWaitSeconds;
        long start = Clock.currentTimeMillis();
        if (this.logger.isFinestEnabled()) {
            this.logger.finest("** we are being asked to shutdown when active = " + String.valueOf(this.active));
        }
        if (!terminate && this.isActive() && this.joined() && !this.partitionService.prepareToSafeShutdown(maxWaitSeconds = this.groupProperties.GRACEFUL_SHUTDOWN_MAX_WAIT.getInteger(), TimeUnit.SECONDS)) {
            this.logger.warning("Graceful shutdown could not be completed in " + maxWaitSeconds + " seconds!");
        }
        if (this.isActive()) {
            if (!terminate) {
                this.clusterService.sendShutdownMessage();
            }
            this.joined.set(false);
            this.setActive(false);
            this.setMasterAddress(null);
            try {
                Runtime.getRuntime().removeShutdownHook(this.shutdownHookThread);
            }
            catch (Throwable ignored) {
                // empty catch block
            }
            this.versionCheck.shutdown();
            if (this.managementCenterService != null) {
                this.managementCenterService.shutdown();
            }
            this.logger.finest("Shutting down node engine");
            this.nodeEngine.shutdown(terminate);
            if (this.multicastService != null) {
                this.logger.finest("Shutting down multicast service");
                this.multicastService.stop();
            }
            this.logger.finest("Shutting down connection manager");
            this.connectionManager.shutdown();
            this.textCommandService.stop();
            this.masterAddress = null;
            if (this.securityContext != null) {
                this.securityContext.destroy();
            }
            this.initializer.destroy();
            this.serializationService.destroy();
            int numThreads = this.threadGroup.activeCount();
            Thread[] threads = new Thread[numThreads * 2];
            numThreads = this.threadGroup.enumerate(threads, false);
            for (int i = 0; i < numThreads; ++i) {
                Thread thread = threads[i];
                if (!thread.isAlive()) continue;
                if (this.logger.isFinestEnabled()) {
                    this.logger.finest("Shutting down thread " + thread.getName());
                }
                thread.interrupt();
            }
            this.logger.info("Hazelcast Shutdown is completed in " + (Clock.currentTimeMillis() - start) + " ms.");
        }
    }

    public void onRestart() {
        this.joined.set(false);
        this.joiner.reset();
        String uuid = UuidUtil.createMemberUuid(this.address);
        if (this.logger.isFinestEnabled()) {
            this.logger.finest("Generated new UUID for local member: " + uuid);
        }
        this.localMember.setUuid(uuid);
    }

    public ILogger getLogger(String name) {
        return this.loggingService.getLogger(name);
    }

    public ILogger getLogger(Class clazz) {
        return this.loggingService.getLogger(clazz);
    }

    public GroupProperties getGroupProperties() {
        return this.groupProperties;
    }

    public TextCommandService getTextCommandService() {
        return this.textCommandService;
    }

    public ConnectionManager getConnectionManager() {
        return this.connectionManager;
    }

    public void inactivate() {
        this.joined.set(false);
        this.setActive(false);
    }

    public ClassLoader getConfigClassLoader() {
        return this.configClassLoader;
    }

    public NodeEngineImpl getNodeEngine() {
        return this.nodeEngine;
    }

    public void setJoined() {
        this.joined.set(true);
    }

    public JoinRequest createJoinRequest() {
        return this.createJoinRequest(false);
    }

    public JoinRequest createJoinRequest(boolean withCredentials) {
        Credentials credentials = withCredentials && this.securityContext != null ? this.securityContext.getCredentialsFactory().newCredentials() : null;
        return new JoinRequest(2, this.buildInfo.getBuildNumber(), this.address, this.localMember.getUuid(), this.createConfigCheck(), credentials, this.clusterService.getSize(), 0, this.config.getMemberAttributeConfig().getAttributes());
    }

    public ConfigCheck createConfigCheck() {
        String joinerType = this.joiner == null ? "" : this.joiner.getType();
        return new ConfigCheck(this.config, joinerType);
    }

    public void rejoin() {
        this.prepareForJoin();
        this.join();
    }

    private void prepareForJoin() {
        this.masterAddress = null;
        this.joined.set(false);
        this.clusterService.reset();
    }

    public void join() {
        if (this.joiner == null) {
            this.logger.warning("No join method is enabled! Starting standalone.");
            this.setAsMaster();
            return;
        }
        try {
            this.prepareForJoin();
            this.joiner.join();
        }
        catch (Throwable e) {
            this.logger.severe("Error while joining the cluster!", e);
        }
        if (!this.joined()) {
            long maxJoinTime = (long)this.groupProperties.MAX_JOIN_SECONDS.getInteger() * 1000L;
            this.logger.severe("Could not join cluster in " + maxJoinTime + " ms. Shutting down now!");
            this.shutdown(true);
        }
    }

    public Joiner getJoiner() {
        return this.joiner;
    }

    Joiner createJoiner() {
        JoinConfig join = this.config.getNetworkConfig().getJoin();
        join.verify();
        if (join.getMulticastConfig().isEnabled() && this.multicastService != null) {
            this.logger.info("Creating MulticastJoiner");
            return new MulticastJoiner(this);
        }
        if (join.getTcpIpConfig().isEnabled()) {
            this.logger.info("Creating TcpIpJoiner");
            return new TcpIpJoiner(this);
        }
        if (join.getAwsConfig().isEnabled()) {
            try {
                this.logger.info("Creating AWSJoiner");
                Class<?> clazz = Class.forName("com.hazelcast.cluster.TcpIpJoinerOverAWS");
                Constructor<?> constructor = clazz.getConstructor(Node.class);
                return (Joiner)constructor.newInstance(this);
            }
            catch (Exception e) {
                this.logger.severe("Error while creating AWSJoiner!", e);
            }
        }
        return null;
    }

    public void setAsMaster() {
        this.logger.finest("This node is being set as the master");
        this.masterAddress = this.address;
        this.setJoined();
    }

    public Config getConfig() {
        return this.config;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    public boolean isActive() {
        return this.active;
    }

    public String toString() {
        return "Node[" + this.getName() + "]";
    }

    public BuildInfo getBuildInfo() {
        return this.buildInfo;
    }

    private Map<String, Object> findMemberAttributes(MemberAttributeConfig attributeConfig) {
        HashMap<String, Object> attributes = new HashMap<String, Object>(attributeConfig.getAttributes());
        Properties properties = System.getProperties();
        for (String key : properties.stringPropertyNames()) {
            if (!key.startsWith("hazelcast.member.attribute.")) continue;
            String shortKey = key.substring("hazelcast.member.attribute.".length());
            String value = properties.getProperty(key);
            attributes.put(shortKey, value);
        }
        return attributes;
    }

    public class NodeShutdownHookThread
    extends Thread {
        NodeShutdownHookThread(String name) {
            super(name);
        }

        @Override
        public void run() {
            try {
                if (Node.this.isActive() && !Node.this.completelyShutdown) {
                    Node.this.completelyShutdown = true;
                    if (Node.this.groupProperties.SHUTDOWNHOOK_ENABLED.getBoolean()) {
                        Node.this.shutdown(true);
                    }
                } else {
                    Node.this.logger.finest("shutdown hook - we are not --> active and not completely down so we are not calling shutdown");
                }
            }
            catch (Exception e) {
                Node.this.logger.warning(e);
            }
        }
    }
}

