/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.client;

import com.hazelcast.map.client.MapPutRequest;
import com.hazelcast.map.operation.TryPutOperation;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.nio.serialization.PortableReader;
import com.hazelcast.nio.serialization.PortableWriter;
import com.hazelcast.spi.Operation;
import java.io.IOException;
import java.util.concurrent.TimeUnit;

public class MapTryPutRequest
extends MapPutRequest {
    private long timeout;

    public MapTryPutRequest() {
    }

    public MapTryPutRequest(String name, Data key, Data value, long threadId, long timeout) {
        super(name, key, value, threadId, -1L);
        this.timeout = timeout;
    }

    @Override
    public int getClassId() {
        return 4;
    }

    @Override
    protected Operation prepareOperation() {
        TryPutOperation op = new TryPutOperation(this.name, this.key, this.value, this.timeout);
        op.setThreadId(this.threadId);
        return op;
    }

    @Override
    public void write(PortableWriter writer) throws IOException {
        writer.writeLong("timeout", this.timeout);
        super.write(writer);
    }

    @Override
    public void read(PortableReader reader) throws IOException {
        this.timeout = reader.readLong("timeout");
        super.read(reader);
    }

    @Override
    public String getMethodName() {
        return "tryPut";
    }

    @Override
    public Object[] getParameters() {
        return new Object[]{this.key, this.value, this.timeout, TimeUnit.MILLISECONDS};
    }
}

