/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.cache.impl.record;

import com.hazelcast.cache.impl.record.CacheRecord;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.Data;
import java.io.IOException;

class AbstractCacheRecord<V>
implements CacheRecord<V> {
    private Data key;
    private V value;
    private long expirationTime = -1L;

    AbstractCacheRecord(Data key, V value, long expirationTime) {
        this.key = key;
        this.value = value;
        this.expirationTime = expirationTime;
    }

    public AbstractCacheRecord() {
    }

    @Override
    public Data getKey() {
        return this.key;
    }

    @Override
    public V getValue() {
        return this.value;
    }

    @Override
    public void setValue(V value) {
        this.value = value;
    }

    @Override
    public long getExpirationTime() {
        return this.expirationTime;
    }

    @Override
    public void setExpirationTime(long expirationTime) {
        this.expirationTime = expirationTime;
    }

    @Override
    public boolean isExpiredAt(long now) {
        return this.expirationTime > -1L && this.expirationTime <= now;
    }

    @Override
    public void writeData(ObjectDataOutput out) throws IOException {
        this.key.writeData(out);
        out.writeLong(this.expirationTime);
        out.writeObject(this.value);
    }

    @Override
    public void readData(ObjectDataInput in) throws IOException {
        this.key = new Data();
        this.key.readData(in);
        this.expirationTime = in.readLong();
        this.value = in.readObject();
    }
}

