/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.operation;

import com.hazelcast.map.MapDataSerializerHook;
import com.hazelcast.map.operation.KeyBasedMapOperation;
import com.hazelcast.map.record.Record;
import com.hazelcast.map.record.RecordInfo;
import com.hazelcast.map.record.Records;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import com.hazelcast.spi.BackupOperation;
import java.io.IOException;

public final class PutBackupOperation
extends KeyBasedMapOperation
implements BackupOperation,
IdentifiedDataSerializable {
    private boolean unlockKey;
    private RecordInfo recordInfo;

    public PutBackupOperation(String name, Data dataKey, Data dataValue, RecordInfo recordInfo) {
        super(name, dataKey, dataValue);
        this.recordInfo = recordInfo;
    }

    public PutBackupOperation(String name, Data dataKey, Data dataValue, RecordInfo recordInfo, boolean unlockKey) {
        super(name, dataKey, dataValue);
        this.unlockKey = unlockKey;
        this.recordInfo = recordInfo;
    }

    public PutBackupOperation() {
    }

    @Override
    public void run() {
        Record record = this.recordStore.putBackup(this.dataKey, this.dataValue, this.ttl);
        if (this.recordInfo != null) {
            Records.applyRecordInfo(record, this.recordInfo);
        }
        if (this.unlockKey) {
            this.recordStore.forceUnlock(this.dataKey);
        }
    }

    @Override
    public Object getResponse() {
        return Boolean.TRUE;
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        super.writeInternal(out);
        out.writeBoolean(this.unlockKey);
        if (this.recordInfo != null) {
            out.writeBoolean(true);
            this.recordInfo.writeData(out);
        } else {
            out.writeBoolean(false);
        }
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        super.readInternal(in);
        this.unlockKey = in.readBoolean();
        boolean hasRecordInfo = in.readBoolean();
        if (hasRecordInfo) {
            this.recordInfo = new RecordInfo();
            this.recordInfo.readData(in);
        }
    }

    public String toString() {
        return "PutBackupOperation{" + this.name + "}";
    }

    @Override
    public int getFactoryId() {
        return MapDataSerializerHook.F_ID;
    }

    @Override
    public int getId() {
        return 3;
    }
}

