/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.replicatedmap.impl;

import com.hazelcast.core.EntryListener;
import com.hazelcast.core.ReplicatedMap;
import com.hazelcast.monitor.LocalReplicatedMapStats;
import com.hazelcast.query.Predicate;
import com.hazelcast.replicatedmap.impl.PreReplicationHook;
import com.hazelcast.replicatedmap.impl.record.AbstractReplicatedRecordStore;
import com.hazelcast.replicatedmap.impl.record.ReplicationPublisher;
import com.hazelcast.spi.AbstractDistributedObject;
import com.hazelcast.spi.InitializingObject;
import com.hazelcast.spi.NodeEngine;
import java.util.Collection;
import java.util.Comparator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;

public class ReplicatedMapProxy<K, V>
extends AbstractDistributedObject
implements ReplicatedMap<K, V>,
InitializingObject {
    private final AbstractReplicatedRecordStore<K, V> replicatedRecordStore;

    ReplicatedMapProxy(NodeEngine nodeEngine, AbstractReplicatedRecordStore<K, V> replicatedRecordStore) {
        super(nodeEngine, replicatedRecordStore.getReplicatedMapService());
        this.replicatedRecordStore = replicatedRecordStore;
    }

    @Override
    public String getName() {
        return this.replicatedRecordStore.getName();
    }

    @Override
    public String getPartitionKey() {
        return this.getName();
    }

    @Override
    public String getServiceName() {
        return "hz:impl:replicatedMapService";
    }

    @Override
    public int size() {
        return this.replicatedRecordStore.size();
    }

    @Override
    public boolean isEmpty() {
        return this.replicatedRecordStore.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.replicatedRecordStore.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.replicatedRecordStore.containsValue(value);
    }

    @Override
    public V get(Object key) {
        return (V)this.replicatedRecordStore.get(key);
    }

    @Override
    public V put(K key, V value) {
        return (V)this.replicatedRecordStore.put(key, value);
    }

    @Override
    public V put(K key, V value, long ttl, TimeUnit timeUnit) {
        return (V)this.replicatedRecordStore.put(key, value, ttl, timeUnit);
    }

    @Override
    public V remove(Object key) {
        return (V)this.replicatedRecordStore.remove(key);
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        if (m == null) {
            throw new NullPointerException("m cannot be null");
        }
        for (Map.Entry<K, V> entry : m.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public void clear() {
        this.replicatedRecordStore.clear(true, true);
    }

    @Override
    public boolean removeEntryListener(String id) {
        return this.replicatedRecordStore.removeEntryListenerInternal(id);
    }

    @Override
    public String addEntryListener(EntryListener<K, V> listener) {
        return this.replicatedRecordStore.addEntryListener(listener, null);
    }

    @Override
    public String addEntryListener(EntryListener<K, V> listener, K key) {
        return this.replicatedRecordStore.addEntryListener(listener, key);
    }

    @Override
    public String addEntryListener(EntryListener<K, V> listener, Predicate<K, V> predicate) {
        return this.replicatedRecordStore.addEntryListener(listener, predicate, null);
    }

    @Override
    public String addEntryListener(EntryListener<K, V> listener, Predicate<K, V> predicate, K key) {
        return this.replicatedRecordStore.addEntryListener(listener, predicate, key);
    }

    @Override
    public Set<K> keySet() {
        return this.replicatedRecordStore.keySet();
    }

    @Override
    public Collection<V> values() {
        return this.replicatedRecordStore.values();
    }

    @Override
    public Collection<V> values(Comparator<V> comparator) {
        return this.replicatedRecordStore.values(comparator);
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return this.replicatedRecordStore.entrySet();
    }

    public boolean storageEquals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ReplicatedMapProxy that = (ReplicatedMapProxy)o;
        return this.replicatedRecordStore.equals(that.replicatedRecordStore);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.replicatedRecordStore.hashCode();
        return result;
    }

    public String toString() {
        return this.getClass().getSimpleName() + " -> " + this.replicatedRecordStore.getName();
    }

    @Override
    public void initialize() {
        this.replicatedRecordStore.initialize();
    }

    public LocalReplicatedMapStats getReplicatedMapStats() {
        return this.replicatedRecordStore.createReplicatedMapStats();
    }

    public void setPreReplicationHook(PreReplicationHook preReplicationHook) {
        ReplicationPublisher replicationPublisher = this.replicatedRecordStore.getReplicationPublisher();
        replicationPublisher.setPreReplicationHook(preReplicationHook);
    }
}

