/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.nio.tcp;

import com.hazelcast.logging.Logger;
import com.hazelcast.nio.SocketWritable;
import com.hazelcast.nio.ascii.SocketTextWriter;
import com.hazelcast.nio.tcp.AbstractSelectionHandler;
import com.hazelcast.nio.tcp.IOSelector;
import com.hazelcast.nio.tcp.SocketClientDataWriter;
import com.hazelcast.nio.tcp.SocketPacketWriter;
import com.hazelcast.nio.tcp.SocketWriter;
import com.hazelcast.nio.tcp.TcpIpConnection;
import com.hazelcast.util.Clock;
import com.hazelcast.util.EmptyStatement;
import com.hazelcast.util.StringUtil;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;

public final class WriteHandler
extends AbstractSelectionHandler
implements Runnable {
    private static final long TIMEOUT = 3L;
    private final Queue<SocketWritable> writeQueue = new ConcurrentLinkedQueue<SocketWritable>();
    private final Queue<SocketWritable> urgencyWriteQueue = new ConcurrentLinkedQueue<SocketWritable>();
    private final AtomicBoolean informSelector = new AtomicBoolean(true);
    private final ByteBuffer buffer;
    private final IOSelector ioSelector;
    private boolean ready;
    private SocketWritable lastWritable;
    private SocketWriter socketWriter;
    private volatile long lastHandle;

    WriteHandler(TcpIpConnection connection, IOSelector ioSelector) {
        super(connection);
        this.ioSelector = ioSelector;
        this.buffer = ByteBuffer.allocate(this.connectionManager.socketSendBufferSize);
    }

    void setProtocol(final String protocol) {
        final CountDownLatch latch = new CountDownLatch(1);
        this.ioSelector.addTask(new Runnable(){

            @Override
            public void run() {
                WriteHandler.this.createWriter(protocol);
                latch.countDown();
            }
        });
        this.ioSelector.wakeup();
        try {
            latch.await(3L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            Logger.getLogger(WriteHandler.class).finest("CountDownLatch::await interrupted", e);
        }
    }

    private void createWriter(String protocol) {
        if (this.socketWriter == null) {
            if ("HZC".equals(protocol)) {
                this.socketWriter = new SocketPacketWriter(this.connection);
                this.buffer.put(StringUtil.stringToBytes("HZC"));
                this.registerWrite();
            } else {
                this.socketWriter = "CB1".equals(protocol) ? new SocketClientDataWriter() : new SocketTextWriter(this.connection);
            }
        }
    }

    public SocketWriter getSocketWriter() {
        return this.socketWriter;
    }

    public void enqueueSocketWritable(SocketWritable socketWritable) {
        if (socketWritable.isUrgent()) {
            this.urgencyWriteQueue.offer(socketWritable);
        } else {
            this.writeQueue.offer(socketWritable);
        }
        if (this.informSelector.compareAndSet(true, false)) {
            this.ioSelector.addTask(this);
            this.ioSelector.wakeup();
        }
    }

    private SocketWritable poll() {
        SocketWritable writable = this.urgencyWriteQueue.poll();
        if (writable == null) {
            writable = this.writeQueue.poll();
        }
        return writable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handle() {
        this.lastHandle = Clock.currentTimeMillis();
        if (!this.connection.live()) {
            return;
        }
        if (this.socketWriter == null) {
            this.logger.log(Level.WARNING, "SocketWriter is not set, creating SocketWriter with CLUSTER protocol!");
            this.createWriter("HZC");
        }
        if (this.lastWritable == null) {
            this.lastWritable = this.poll();
            if (this.lastWritable == null && this.buffer.position() == 0) {
                this.ready = true;
                return;
            }
        }
        try {
            this.writeBuffer();
        }
        catch (Throwable t) {
            this.logger.severe("Fatal Error at WriteHandler for endPoint: " + this.connection.getEndPoint(), t);
        }
        finally {
            this.ready = false;
            this.registerWrite();
        }
    }

    private void writeBuffer() throws Exception {
        boolean complete;
        while (this.buffer.hasRemaining() && this.lastWritable != null && (complete = this.socketWriter.write(this.lastWritable, this.buffer))) {
            this.lastWritable = this.poll();
        }
        if (this.buffer.position() > 0) {
            this.buffer.flip();
            try {
                this.socketChannel.write(this.buffer);
            }
            catch (Exception e) {
                this.lastWritable = null;
                this.handleSocketException(e);
                return;
            }
            if (this.buffer.hasRemaining()) {
                this.buffer.compact();
            } else {
                this.buffer.clear();
            }
        }
    }

    @Override
    public void run() {
        this.informSelector.set(true);
        if (this.ready) {
            this.handle();
        } else {
            this.registerWrite();
        }
        this.ready = false;
    }

    private void registerWrite() {
        this.registerOp(this.ioSelector.getSelector(), 4);
    }

    public void shutdown() {
        while (this.poll() != null) {
        }
        final CountDownLatch latch = new CountDownLatch(1);
        this.ioSelector.addTask(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    WriteHandler.this.socketChannel.closeOutbound();
                }
                catch (IOException e) {
                    WriteHandler.this.logger.finest("Error while closing outbound", e);
                }
                finally {
                    latch.countDown();
                }
            }
        });
        this.ioSelector.wakeup();
        try {
            latch.await(3L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            EmptyStatement.ignore(e);
        }
    }

    long getLastHandle() {
        return this.lastHandle;
    }
}

