/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.cache.impl;

import com.hazelcast.cache.impl.AbstractCacheProxyExtension;
import com.hazelcast.cache.impl.CacheEntryProcessorResult;
import com.hazelcast.cache.impl.CacheEventListenerAdaptor;
import com.hazelcast.cache.impl.CacheProxyUtil;
import com.hazelcast.cache.impl.CacheService;
import com.hazelcast.cache.impl.ClusterWideIterator;
import com.hazelcast.cache.impl.HazelcastCacheManager;
import com.hazelcast.cache.impl.HazelcastServerCacheManager;
import com.hazelcast.cache.impl.operation.CacheContainsKeyOperation;
import com.hazelcast.cache.impl.operation.CacheEntryProcessorOperation;
import com.hazelcast.cache.impl.operation.CacheListenerRegistrationOperation;
import com.hazelcast.cache.impl.operation.CacheLoadAllOperationFactory;
import com.hazelcast.config.CacheConfig;
import com.hazelcast.instance.MemberImpl;
import com.hazelcast.logging.ILogger;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.spi.InternalCompletableFuture;
import com.hazelcast.spi.NodeEngine;
import com.hazelcast.spi.OperationService;
import com.hazelcast.util.ExceptionUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.cache.Cache;
import javax.cache.CacheException;
import javax.cache.CacheManager;
import javax.cache.configuration.CacheEntryListenerConfiguration;
import javax.cache.configuration.Configuration;
import javax.cache.expiry.ExpiryPolicy;
import javax.cache.integration.CompletionListener;
import javax.cache.processor.EntryProcessor;
import javax.cache.processor.EntryProcessorException;
import javax.cache.processor.EntryProcessorResult;

public class CacheProxy<K, V>
extends AbstractCacheProxyExtension<K, V> {
    protected final ILogger logger;
    private HazelcastCacheManager cacheManager;

    protected CacheProxy(CacheConfig cacheConfig, NodeEngine nodeEngine, CacheService cacheService, HazelcastServerCacheManager cacheManager) {
        super(cacheConfig, nodeEngine, cacheService);
        this.cacheManager = cacheManager;
        this.logger = this.getNodeEngine().getLogger(this.getClass());
    }

    public V get(K key) {
        return (V)this.get((Object)key, (ExpiryPolicy)null);
    }

    public Map<K, V> getAll(Set<? extends K> keys) {
        return this.getAll((Set)keys, (ExpiryPolicy)null);
    }

    public boolean containsKey(K key) {
        this.ensureOpen();
        CacheProxyUtil.validateNotNull(key);
        Data k = this.serializationService.toData(key);
        CacheContainsKeyOperation op = new CacheContainsKeyOperation(this.getDistributedObjectName(), k);
        InternalCompletableFuture f = this.getNodeEngine().getOperationService().invokeOnPartition(this.getServiceName(), op, CacheProxyUtil.getPartitionId(this.getNodeEngine(), k));
        return (Boolean)f.getSafely();
    }

    public void loadAll(Set<? extends K> keys, boolean replaceExistingValues, CompletionListener completionListener) {
        this.ensureOpen();
        CacheProxyUtil.validateNotNull(keys);
        for (K key : keys) {
            CacheProxyUtil.validateConfiguredTypes(this.cacheConfig, key);
        }
        this.validateCacheLoader(completionListener);
        HashSet<Data> keysData = new HashSet<Data>();
        for (K key : keys) {
            keysData.add(this.serializationService.toData(key));
        }
        CacheLoadAllOperationFactory operationFactory = new CacheLoadAllOperationFactory(this.getDistributedObjectName(), keysData, replaceExistingValues);
        try {
            this.submitLoadAllTask(operationFactory, completionListener);
        }
        catch (Exception e) {
            if (completionListener != null) {
                completionListener.onException(e);
            }
            throw new CacheException((Throwable)e);
        }
    }

    public void put(K key, V value) {
        this.put((Object)key, (Object)value, (ExpiryPolicy)null);
    }

    public V getAndPut(K key, V value) {
        return (V)this.getAndPut((Object)key, (Object)value, (ExpiryPolicy)null);
    }

    public void putAll(Map<? extends K, ? extends V> map) {
        this.putAll((Map)map, (ExpiryPolicy)null);
    }

    public boolean putIfAbsent(K key, V value) {
        return this.putIfAbsent((Object)key, (Object)value, (ExpiryPolicy)null);
    }

    public boolean remove(K key) {
        InternalCompletableFuture f = this.removeAsyncInternal(key, null, false, false, true);
        try {
            return (Boolean)f.get();
        }
        catch (Throwable e) {
            throw ExceptionUtil.rethrowAllowedTypeFirst(e, CacheException.class);
        }
    }

    public boolean remove(K key, V oldValue) {
        InternalCompletableFuture f = this.removeAsyncInternal(key, oldValue, true, false, true);
        try {
            return (Boolean)f.get();
        }
        catch (Throwable e) {
            throw ExceptionUtil.rethrowAllowedTypeFirst(e, CacheException.class);
        }
    }

    public V getAndRemove(K key) {
        InternalCompletableFuture f = this.removeAsyncInternal(key, null, false, true, true);
        try {
            return f.get();
        }
        catch (Throwable e) {
            throw ExceptionUtil.rethrowAllowedTypeFirst(e, CacheException.class);
        }
    }

    public boolean replace(K key, V oldValue, V newValue) {
        return this.replace((Object)key, (Object)oldValue, (Object)newValue, (ExpiryPolicy)null);
    }

    public boolean replace(K key, V value) {
        ExpiryPolicy expiryPolicy = null;
        return this.replace((Object)key, (Object)value, expiryPolicy);
    }

    public V getAndReplace(K key, V value) {
        return (V)this.getAndReplace((Object)key, (Object)value, (ExpiryPolicy)null);
    }

    public void removeAll(Set<? extends K> keys) {
        this.ensureOpen();
        CacheProxyUtil.validateNotNull(keys);
        this.removeAllInternal(keys, true);
    }

    public void removeAll() {
        this.ensureOpen();
        this.removeAllInternal(null, true);
    }

    public void clear() {
        this.ensureOpen();
        this.removeAllInternal(null, false);
    }

    public <C extends Configuration<K, V>> C getConfiguration(Class<C> clazz) {
        if (clazz.isInstance(this.cacheConfig)) {
            return (C)((Configuration)clazz.cast(this.cacheConfig.getAsReadOnly()));
        }
        throw new IllegalArgumentException("The configuration class " + clazz + " is not supported by this implementation");
    }

    public <T> T invoke(K key, EntryProcessor<K, V, T> entryProcessor, Object ... arguments) throws EntryProcessorException {
        this.ensureOpen();
        CacheProxyUtil.validateNotNull(key);
        if (entryProcessor == null) {
            throw new NullPointerException("Entry Processor is null");
        }
        Data k = this.serializationService.toData(key);
        Integer completionId = this.registerCompletionLatch(1);
        CacheEntryProcessorOperation op = new CacheEntryProcessorOperation(this.getDistributedObjectName(), k, completionId, entryProcessor, arguments);
        try {
            InternalCompletableFuture f = this.getNodeEngine().getOperationService().invokeOnPartition(this.getServiceName(), op, CacheProxyUtil.getPartitionId(this.getNodeEngine(), k));
            Object safely = f.getSafely();
            this.waitCompletionLatch(completionId);
            return (T)safely;
        }
        catch (CacheException ce) {
            this.deregisterCompletionLatch(completionId);
            throw ce;
        }
        catch (Exception e) {
            this.deregisterCompletionLatch(completionId);
            throw new EntryProcessorException((Throwable)e);
        }
    }

    public <T> Map<K, EntryProcessorResult<T>> invokeAll(Set<? extends K> keys, EntryProcessor<K, V, T> entryProcessor, Object ... arguments) {
        this.ensureOpen();
        CacheProxyUtil.validateNotNull(keys);
        if (entryProcessor == null) {
            throw new NullPointerException("Entry Processor is null");
        }
        HashMap<K, CacheEntryProcessorResult<T>> allResult = new HashMap<K, CacheEntryProcessorResult<T>>();
        for (K key : keys) {
            CacheEntryProcessorResult<T> ceResult;
            try {
                T result = this.invoke(key, entryProcessor, arguments);
                ceResult = result != null ? new CacheEntryProcessorResult<T>(result) : null;
            }
            catch (Exception e) {
                ceResult = new CacheEntryProcessorResult<T>(e);
            }
            if (ceResult == null) continue;
            allResult.put(key, ceResult);
        }
        return allResult;
    }

    public String getName() {
        return this.name;
    }

    public CacheManager getCacheManager() {
        return this.cacheManager;
    }

    public <T> T unwrap(Class<T> clazz) {
        if (clazz.isAssignableFrom(this.getClass())) {
            return clazz.cast(this);
        }
        throw new IllegalArgumentException("Unwrapping to " + clazz + " is not supported by this implementation");
    }

    public void registerCacheEntryListener(CacheEntryListenerConfiguration<K, V> cacheEntryListenerConfiguration) {
        this.ensureOpen();
        if (cacheEntryListenerConfiguration == null) {
            throw new NullPointerException("CacheEntryListenerConfiguration can't be null");
        }
        CacheService service = this.getService();
        CacheEventListenerAdaptor<K, V> entryListener = new CacheEventListenerAdaptor<K, V>(this, cacheEntryListenerConfiguration, this.getNodeEngine().getSerializationService());
        String regId = service.registerListener(this.getDistributedObjectName(), entryListener);
        if (regId != null) {
            this.cacheConfig.addCacheEntryListenerConfiguration((CacheEntryListenerConfiguration)cacheEntryListenerConfiguration);
            this.addListenerLocally(regId, cacheEntryListenerConfiguration);
            this.updateCacheListenerConfigOnOtherNodes(cacheEntryListenerConfiguration, true);
        }
    }

    public void deregisterCacheEntryListener(CacheEntryListenerConfiguration<K, V> cacheEntryListenerConfiguration) {
        if (cacheEntryListenerConfiguration == null) {
            throw new NullPointerException("CacheEntryListenerConfiguration can't be null");
        }
        CacheService service = this.getService();
        String regId = this.removeListenerLocally(cacheEntryListenerConfiguration);
        if (regId != null) {
            if (!service.deregisterListener(this.getDistributedObjectName(), regId)) {
                this.addListenerLocally(regId, cacheEntryListenerConfiguration);
            } else {
                this.cacheConfig.removeCacheEntryListenerConfiguration((CacheEntryListenerConfiguration)cacheEntryListenerConfiguration);
                this.deregisterCompletionListener();
                this.updateCacheListenerConfigOnOtherNodes(cacheEntryListenerConfiguration, false);
            }
        }
    }

    protected void updateCacheListenerConfigOnOtherNodes(CacheEntryListenerConfiguration<K, V> cacheEntryListenerConfiguration, boolean isRegister) {
        OperationService operationService = this.getNodeEngine().getOperationService();
        Collection<MemberImpl> members = this.getNodeEngine().getClusterService().getMemberList();
        ArrayList futures = new ArrayList();
        for (MemberImpl member : members) {
            if (member.localMember()) continue;
            CacheListenerRegistrationOperation op = new CacheListenerRegistrationOperation(this.getDistributedObjectName(), cacheEntryListenerConfiguration, isRegister);
            InternalCompletableFuture future = operationService.invokeOnTarget("hz:impl:cacheService", op, member.getAddress());
            futures.add(future);
        }
    }

    public Iterator<Cache.Entry<K, V>> iterator() {
        this.ensureOpen();
        return new ClusterWideIterator(this);
    }
}

