/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.cache.impl.client;

import com.hazelcast.cache.impl.client.AbstractCacheRequest;
import com.hazelcast.cache.impl.operation.CachePutOperation;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.nio.serialization.PortableReader;
import com.hazelcast.nio.serialization.PortableWriter;
import com.hazelcast.spi.Operation;
import java.io.IOException;
import javax.cache.expiry.ExpiryPolicy;

public class CachePutRequest
extends AbstractCacheRequest {
    protected Data key;
    protected Data value;
    protected ExpiryPolicy expiryPolicy;
    protected boolean get;
    private int completionId;

    public CachePutRequest() {
    }

    public CachePutRequest(String name, Data key, Data value) {
        super(name);
        this.key = key;
        this.value = value;
        this.expiryPolicy = null;
    }

    public CachePutRequest(String name, Data key, Data value, ExpiryPolicy expiryPolicy) {
        super(name);
        this.key = key;
        this.value = value;
        this.expiryPolicy = expiryPolicy;
    }

    public CachePutRequest(String name, Data key, Data value, ExpiryPolicy expiryPolicy, boolean get) {
        super(name);
        this.key = key;
        this.value = value;
        this.expiryPolicy = expiryPolicy;
        this.get = get;
    }

    @Override
    public int getClassId() {
        return 2;
    }

    @Override
    protected Object getKey() {
        return this.key;
    }

    @Override
    protected Operation prepareOperation() {
        return new CachePutOperation(this.name, this.key, this.value, this.expiryPolicy, this.get, this.completionId);
    }

    @Override
    public void write(PortableWriter writer) throws IOException {
        writer.writeUTF("n", this.name);
        writer.writeInt("c", this.completionId);
        writer.writeBoolean("g", this.get);
        ObjectDataOutput out = writer.getRawDataOutput();
        this.key.writeData(out);
        this.value.writeData(out);
        out.writeObject(this.expiryPolicy);
    }

    @Override
    public void read(PortableReader reader) throws IOException {
        this.name = reader.readUTF("n");
        this.completionId = reader.readInt("c");
        this.get = reader.readBoolean("g");
        ObjectDataInput in = reader.getRawDataInput();
        this.key = new Data();
        this.key.readData(in);
        this.value = new Data();
        this.value.readData(in);
        this.expiryPolicy = (ExpiryPolicy)in.readObject();
    }

    @Override
    public void setCompletionId(Integer completionId) {
        this.completionId = completionId != null ? completionId : -1;
    }
}

