/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.config;

import com.hazelcast.config.SemaphoreConfigReadOnly;
import com.hazelcast.util.ValidationUtil;

public class SemaphoreConfig {
    public static final int DEFAULT_SYNC_BACKUP_COUNT = 1;
    public static final int DEFAULT_ASYNC_BACKUP_COUNT = 0;
    private String name;
    private int initialPermits;
    private int backupCount = 1;
    private int asyncBackupCount = 0;
    private SemaphoreConfigReadOnly readOnly;

    public SemaphoreConfig() {
    }

    public SemaphoreConfig(SemaphoreConfig config) {
        ValidationUtil.isNotNull(config, "config");
        this.name = config.getName();
        this.initialPermits = config.getInitialPermits();
        this.backupCount = config.getBackupCount();
        this.asyncBackupCount = config.getAsyncBackupCount();
    }

    public SemaphoreConfigReadOnly getAsReadOnly() {
        if (this.readOnly == null) {
            this.readOnly = new SemaphoreConfigReadOnly(this);
        }
        return this.readOnly;
    }

    public String getName() {
        return this.name;
    }

    public SemaphoreConfig setName(String name) {
        this.name = ValidationUtil.hasText(name, "name");
        return this;
    }

    public int getInitialPermits() {
        return this.initialPermits;
    }

    public SemaphoreConfig setInitialPermits(int initialPermits) {
        this.initialPermits = initialPermits;
        return this;
    }

    public int getBackupCount() {
        return this.backupCount;
    }

    public SemaphoreConfig setBackupCount(int backupCount) {
        if (backupCount < 0) {
            throw new IllegalArgumentException("backupCount can't be smaller than 0");
        }
        this.backupCount = backupCount;
        return this;
    }

    public int getAsyncBackupCount() {
        return this.asyncBackupCount;
    }

    public SemaphoreConfig setAsyncBackupCount(int asyncBackupCount) {
        if (this.backupCount < 0) {
            throw new IllegalArgumentException("asyncBackupCount can't be smaller than 0");
        }
        this.asyncBackupCount = asyncBackupCount;
        return this;
    }

    public int getTotalBackupCount() {
        return this.asyncBackupCount + this.backupCount;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("SemaphoreConfig{");
        sb.append("name='").append(this.name).append('\'');
        sb.append(", initialPermits=").append(this.initialPermits);
        sb.append(", backupCount=").append(this.backupCount);
        sb.append(", asyncBackupCount=").append(this.asyncBackupCount);
        sb.append('}');
        return sb.toString();
    }
}

