/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.operation;

import com.hazelcast.core.MemberLeftException;
import com.hazelcast.map.MapContextQuerySupport;
import com.hazelcast.map.MapService;
import com.hazelcast.map.MapServiceContext;
import com.hazelcast.map.QueryResult;
import com.hazelcast.map.operation.AbstractMapOperation;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.partition.InternalPartitionService;
import com.hazelcast.query.PagingPredicate;
import com.hazelcast.query.Predicate;
import com.hazelcast.query.impl.IndexService;
import com.hazelcast.query.impl.QueryResultEntryImpl;
import com.hazelcast.query.impl.QueryableEntry;
import com.hazelcast.spi.ExceptionAction;
import com.hazelcast.spi.NodeEngine;
import com.hazelcast.spi.exception.TargetNotMemberException;
import com.hazelcast.util.FutureUtil;
import com.hazelcast.util.SortingUtil;
import com.hazelcast.util.executor.ManagedExecutorService;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;

public class QueryOperation
extends AbstractMapOperation {
    private static final long QUERY_EXECUTION_TIMEOUT_MINUTES = 5L;
    Predicate predicate;
    QueryResult result;
    PagingPredicate pagingPredicate;

    public QueryOperation(String mapName, Predicate predicate) {
        super(mapName);
        this.predicate = predicate;
        if (predicate instanceof PagingPredicate) {
            this.pagingPredicate = (PagingPredicate)predicate;
        }
    }

    public QueryOperation() {
    }

    @Override
    public void run() throws Exception {
        NodeEngine nodeEngine = this.getNodeEngine();
        InternalPartitionService partitionService = nodeEngine.getPartitionService();
        Collection<Integer> initialPartitions = this.mapService.getMapServiceContext().getOwnedPartitions();
        int partitionStateVersion = partitionService.getPartitionStateVersion();
        IndexService indexService = this.mapService.getMapServiceContext().getMapContainer(this.name).getIndexService();
        Set<QueryableEntry> entries = null;
        if (!partitionService.hasOnGoingMigrationLocal()) {
            entries = indexService.query(this.predicate);
        }
        this.result = new QueryResult();
        if (entries != null) {
            for (QueryableEntry entry : entries) {
                this.result.add(new QueryResultEntryImpl(entry.getKeyData(), entry.getKeyData(), entry.getValueData()));
            }
        } else if (this.pagingPredicate != null) {
            this.runParallelForPaging(initialPartitions);
        } else {
            this.runParallel(initialPartitions);
        }
        Collection<Integer> finalPartitions = this.mapService.getMapServiceContext().getOwnedPartitions();
        if (initialPartitions.equals(finalPartitions)) {
            this.result.setPartitionIds(finalPartitions);
        }
        if (this.mapContainer.getMapConfig().isStatisticsEnabled()) {
            MapServiceContext mapServiceContext = ((MapService)this.getService()).getMapServiceContext();
            mapServiceContext.getLocalMapStatsProvider().getLocalMapStatsImpl(this.name).incrementOtherOperations();
        }
        this.checkPartitionStateChanges(partitionService, partitionStateVersion);
    }

    private void checkPartitionStateChanges(InternalPartitionService partitionService, int partitionStateVersion) {
        if (partitionStateVersion != partitionService.getPartitionStateVersion()) {
            this.getLogger().info("Partition assignments changed while executing query: " + this.predicate);
        }
    }

    protected void runParallel(Collection<Integer> initialPartitions) throws InterruptedException, ExecutionException {
        NodeEngine nodeEngine = this.getNodeEngine();
        ManagedExecutorService executor = nodeEngine.getExecutionService().getExecutor("hz:query");
        ArrayList<Future<Collection<QueryableEntry>>> lsFutures = new ArrayList<Future<Collection<QueryableEntry>>>(initialPartitions.size());
        for (Integer partitionId : initialPartitions) {
            Future<Collection<QueryableEntry>> f = executor.submit(new PartitionCallable(partitionId));
            lsFutures.add(f);
        }
        Collection<Collection<QueryableEntry>> returnedResults = QueryOperation.getResult(lsFutures);
        for (Collection<QueryableEntry> returnedResult : returnedResults) {
            if (returnedResult == null) continue;
            for (QueryableEntry entry : returnedResult) {
                this.result.add(new QueryResultEntryImpl(entry.getKeyData(), entry.getKeyData(), entry.getValueData()));
            }
        }
    }

    private static Collection<Collection<QueryableEntry>> getResult(List<Future<Collection<QueryableEntry>>> lsFutures) {
        return FutureUtil.returnWithDeadline(lsFutures, 5L, TimeUnit.MINUTES, FutureUtil.RETHROW_EVERYTHING);
    }

    protected void runParallelForPaging(Collection<Integer> initialPartitions) throws InterruptedException, ExecutionException {
        NodeEngine nodeEngine = this.getNodeEngine();
        ManagedExecutorService executor = nodeEngine.getExecutionService().getExecutor("hz:query");
        ArrayList<Future<Collection<QueryableEntry>>> lsFutures = new ArrayList<Future<Collection<QueryableEntry>>>(initialPartitions.size());
        Comparator<Map.Entry> wrapperComparator = SortingUtil.newComparator(this.pagingPredicate);
        for (Integer partitionId : initialPartitions) {
            Future<Collection<QueryableEntry>> f = executor.submit(new PartitionCallable(partitionId));
            lsFutures.add(f);
        }
        List<QueryableEntry> toMerge = new LinkedList<QueryableEntry>();
        Collection<Collection<QueryableEntry>> returnedResults = QueryOperation.getResult(lsFutures);
        for (Collection<QueryableEntry> returnedResult : returnedResults) {
            toMerge.addAll(returnedResult);
        }
        Collections.sort(toMerge, wrapperComparator);
        if (toMerge.size() > this.pagingPredicate.getPageSize()) {
            toMerge = toMerge.subList(0, this.pagingPredicate.getPageSize());
        }
        for (QueryableEntry entry : toMerge) {
            this.result.add(new QueryResultEntryImpl(entry.getKeyData(), entry.getKeyData(), entry.getValueData()));
        }
    }

    @Override
    public ExceptionAction onException(Throwable throwable) {
        if (throwable instanceof MemberLeftException) {
            return ExceptionAction.THROW_EXCEPTION;
        }
        if (throwable instanceof TargetNotMemberException) {
            return ExceptionAction.THROW_EXCEPTION;
        }
        return super.onException(throwable);
    }

    @Override
    public Object getResponse() {
        return this.result;
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        super.writeInternal(out);
        out.writeUTF(this.name);
        out.writeObject(this.predicate);
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        super.readInternal(in);
        this.name = in.readUTF();
        this.predicate = (Predicate)in.readObject();
        if (this.predicate instanceof PagingPredicate) {
            this.pagingPredicate = (PagingPredicate)this.predicate;
        }
    }

    private final class PartitionCallable
    implements Callable<Collection<QueryableEntry>> {
        final int partition;

        private PartitionCallable(int partitionId) {
            this.partition = partitionId;
        }

        @Override
        public Collection<QueryableEntry> call() throws Exception {
            MapContextQuerySupport mapContextQuerySupport = QueryOperation.this.mapService.getMapServiceContext().getMapContextQuerySupport();
            return mapContextQuerySupport.queryOnPartition(QueryOperation.this.name, QueryOperation.this.predicate, this.partition);
        }
    }
}

