/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.operation;

import com.hazelcast.map.MapDataSerializerHook;
import com.hazelcast.map.MapService;
import com.hazelcast.map.MapServiceContext;
import com.hazelcast.map.RecordStore;
import com.hazelcast.map.operation.KeyBasedMapOperation;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import com.hazelcast.spi.BackupOperation;
import java.io.IOException;

public final class RemoveBackupOperation
extends KeyBasedMapOperation
implements BackupOperation,
IdentifiedDataSerializable {
    private boolean unlockKey;

    public RemoveBackupOperation(String name, Data dataKey) {
        super(name, dataKey);
    }

    public RemoveBackupOperation(String name, Data dataKey, boolean unlockKey) {
        super(name, dataKey);
        this.unlockKey = unlockKey;
    }

    public RemoveBackupOperation() {
    }

    @Override
    public void run() {
        MapService mapService = (MapService)this.getService();
        MapServiceContext mapServiceContext = mapService.getMapServiceContext();
        int partitionId = this.getPartitionId();
        RecordStore recordStore = mapServiceContext.getRecordStore(partitionId, this.name);
        recordStore.removeBackup(this.dataKey);
        if (this.unlockKey) {
            recordStore.forceUnlock(this.dataKey);
        }
    }

    @Override
    public void afterRun() throws Exception {
        this.evict(true);
    }

    @Override
    public Object getResponse() {
        return Boolean.TRUE;
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        super.writeInternal(out);
        out.writeBoolean(this.unlockKey);
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        super.readInternal(in);
        this.unlockKey = in.readBoolean();
    }

    @Override
    public int getFactoryId() {
        return MapDataSerializerHook.F_ID;
    }

    @Override
    public int getId() {
        return 4;
    }
}

