/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client;

import com.hazelcast.client.HazelcastClient;
import com.hazelcast.client.config.ClientConfig;
import com.hazelcast.config.Config;
import com.hazelcast.core.Client;
import com.hazelcast.core.ClientService;
import com.hazelcast.core.Cluster;
import com.hazelcast.core.DistributedObject;
import com.hazelcast.core.DistributedObjectListener;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.HazelcastInstanceNotActiveException;
import com.hazelcast.core.IAtomicLong;
import com.hazelcast.core.IAtomicReference;
import com.hazelcast.core.ICountDownLatch;
import com.hazelcast.core.IExecutorService;
import com.hazelcast.core.IList;
import com.hazelcast.core.ILock;
import com.hazelcast.core.IMap;
import com.hazelcast.core.IQueue;
import com.hazelcast.core.ISemaphore;
import com.hazelcast.core.ISet;
import com.hazelcast.core.ITopic;
import com.hazelcast.core.IdGenerator;
import com.hazelcast.core.LifecycleService;
import com.hazelcast.core.MultiMap;
import com.hazelcast.core.PartitionService;
import com.hazelcast.core.ReplicatedMap;
import com.hazelcast.instance.TerminatedLifecycleService;
import com.hazelcast.logging.LoggingService;
import com.hazelcast.mapreduce.JobTracker;
import com.hazelcast.nio.serialization.SerializationService;
import com.hazelcast.transaction.TransactionContext;
import com.hazelcast.transaction.TransactionException;
import com.hazelcast.transaction.TransactionOptions;
import com.hazelcast.transaction.TransactionalTask;
import java.util.Collection;
import java.util.concurrent.ConcurrentMap;

public final class HazelcastClientProxy
implements HazelcastInstance {
    volatile HazelcastClient client;

    HazelcastClientProxy(HazelcastClient client) {
        this.client = client;
    }

    @Override
    public Config getConfig() {
        return this.getClient().getConfig();
    }

    @Override
    public String getName() {
        return this.getClient().getName();
    }

    @Override
    public <E> IQueue<E> getQueue(String name) {
        return this.getClient().getQueue(name);
    }

    @Override
    public <E> ITopic<E> getTopic(String name) {
        return this.getClient().getTopic(name);
    }

    @Override
    public <E> ISet<E> getSet(String name) {
        return this.getClient().getSet(name);
    }

    @Override
    public <E> IList<E> getList(String name) {
        return this.getClient().getList(name);
    }

    @Override
    public <K, V> IMap<K, V> getMap(String name) {
        return this.getClient().getMap(name);
    }

    @Override
    public <K, V> MultiMap<K, V> getMultiMap(String name) {
        return this.getClient().getMultiMap(name);
    }

    @Override
    public <K, V> ReplicatedMap<K, V> getReplicatedMap(String name) {
        return this.getClient().getReplicatedMap(name);
    }

    @Override
    public JobTracker getJobTracker(String name) {
        return this.getClient().getJobTracker(name);
    }

    @Override
    public ILock getLock(Object key) {
        return this.getClient().getLock(key);
    }

    @Override
    public ILock getLock(String key) {
        return this.getClient().getLock(key);
    }

    @Override
    public Cluster getCluster() {
        return this.getClient().getCluster();
    }

    @Override
    public Client getLocalEndpoint() {
        return this.getClient().getLocalEndpoint();
    }

    @Override
    public IExecutorService getExecutorService(String name) {
        return this.getClient().getExecutorService(name);
    }

    @Override
    public <T> T executeTransaction(TransactionalTask<T> task) throws TransactionException {
        return this.getClient().executeTransaction(task);
    }

    @Override
    public <T> T executeTransaction(TransactionOptions options, TransactionalTask<T> task) throws TransactionException {
        return this.getClient().executeTransaction(options, task);
    }

    @Override
    public TransactionContext newTransactionContext() {
        return this.getClient().newTransactionContext();
    }

    @Override
    public TransactionContext newTransactionContext(TransactionOptions options) {
        return this.getClient().newTransactionContext(options);
    }

    @Override
    public IdGenerator getIdGenerator(String name) {
        return this.getClient().getIdGenerator(name);
    }

    @Override
    public IAtomicLong getAtomicLong(String name) {
        return this.getClient().getAtomicLong(name);
    }

    @Override
    public <E> IAtomicReference<E> getAtomicReference(String name) {
        return this.getClient().getAtomicReference(name);
    }

    @Override
    public ICountDownLatch getCountDownLatch(String name) {
        return this.getClient().getCountDownLatch(name);
    }

    @Override
    public ISemaphore getSemaphore(String name) {
        return this.getClient().getSemaphore(name);
    }

    @Override
    public Collection<DistributedObject> getDistributedObjects() {
        return this.getClient().getDistributedObjects();
    }

    @Override
    public String addDistributedObjectListener(DistributedObjectListener distributedObjectListener) {
        return this.getClient().addDistributedObjectListener(distributedObjectListener);
    }

    @Override
    public boolean removeDistributedObjectListener(String registrationId) {
        return this.getClient().removeDistributedObjectListener(registrationId);
    }

    @Override
    public PartitionService getPartitionService() {
        return this.getClient().getPartitionService();
    }

    @Override
    public ClientService getClientService() {
        return this.getClient().getClientService();
    }

    @Override
    public LoggingService getLoggingService() {
        return this.getClient().getLoggingService();
    }

    @Override
    public LifecycleService getLifecycleService() {
        HazelcastClient hz = this.client;
        return hz != null ? hz.getLifecycleService() : new TerminatedLifecycleService();
    }

    @Override
    @Deprecated
    public <T extends DistributedObject> T getDistributedObject(String serviceName, Object id) {
        return this.getClient().getDistributedObject(serviceName, id);
    }

    @Override
    public <T extends DistributedObject> T getDistributedObject(String serviceName, String name) {
        return this.getClient().getDistributedObject(serviceName, name);
    }

    @Override
    public ConcurrentMap<String, Object> getUserContext() {
        return this.getClient().getUserContext();
    }

    public ClientConfig getClientConfig() {
        return this.getClient().getClientConfig();
    }

    @Override
    public void shutdown() {
        this.getLifecycleService().shutdown();
    }

    public SerializationService getSerializationService() {
        return this.getClient().getSerializationService();
    }

    private HazelcastClient getClient() {
        HazelcastClient c = this.client;
        if (c == null || !c.getLifecycleService().isRunning()) {
            throw new HazelcastInstanceNotActiveException();
        }
        return c;
    }
}

