/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.instance;

import com.hazelcast.instance.DefaultNodeInitializer;
import com.hazelcast.instance.NodeInitializer;
import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.Logger;
import com.hazelcast.util.ServiceLoader;
import java.util.Iterator;

public final class NodeInitializerFactory {
    private static final ILogger LOGGER = Logger.getLogger(NodeInitializerFactory.class);
    private static final String FACTORY_ID = "com.hazelcast.NodeInitializer";

    private NodeInitializerFactory() {
    }

    public static NodeInitializer create(ClassLoader classLoader) {
        try {
            Iterator<NodeInitializer> iter = ServiceLoader.iterator(NodeInitializer.class, FACTORY_ID, classLoader);
            while (iter.hasNext()) {
                NodeInitializer initializer = iter.next();
                if (initializer.getClass().equals(DefaultNodeInitializer.class)) continue;
                return initializer;
            }
        }
        catch (Exception e) {
            LOGGER.warning("NodeInitializer could not be instantiated! => " + e.getClass().getName() + ": " + e.getMessage());
        }
        return new DefaultNodeInitializer();
    }
}

