/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.operation;

import com.hazelcast.map.operation.BasePutOperation;
import com.hazelcast.nio.IOUtil;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.Data;
import java.io.IOException;

public class ReplaceIfSameOperation
extends BasePutOperation {
    private Data testValue;
    private boolean successful;

    public ReplaceIfSameOperation(String name, Data dataKey, Data testValue, Data value) {
        super(name, dataKey, value);
        this.testValue = testValue;
    }

    public ReplaceIfSameOperation() {
    }

    @Override
    public void run() {
        this.successful = this.recordStore.replace(this.dataKey, this.testValue, this.dataValue);
        if (this.successful) {
            this.dataOldValue = this.testValue;
        }
    }

    @Override
    public void afterRun() {
        if (this.successful) {
            super.afterRun();
        }
    }

    @Override
    public Object getResponse() {
        return this.successful;
    }

    @Override
    public boolean shouldBackup() {
        return this.successful;
    }

    @Override
    public void onWaitExpire() {
        this.getResponseHandler().sendResponse(false);
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        super.writeInternal(out);
        IOUtil.writeNullableData(out, this.testValue);
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        super.readInternal(in);
        this.testValue = IOUtil.readNullableData(in);
    }

    @Override
    public String toString() {
        return "ReplaceIfSameOperation{" + this.name + "}";
    }
}

