/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.queue.impl;

import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.queue.impl.QueueOperation;
import com.hazelcast.spi.BackupOperation;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class AddAllBackupOperation
extends QueueOperation
implements BackupOperation {
    private Map<Long, Data> dataMap;

    public AddAllBackupOperation() {
    }

    public AddAllBackupOperation(String name, Map<Long, Data> dataMap) {
        super(name);
        this.dataMap = dataMap;
    }

    @Override
    public void run() throws Exception {
        this.getOrCreateContainer().addAllBackup(this.dataMap);
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        super.writeInternal(out);
        out.writeInt(this.dataMap.size());
        for (Map.Entry<Long, Data> entry : this.dataMap.entrySet()) {
            long itemId = entry.getKey();
            Data value = entry.getValue();
            out.writeLong(itemId);
            value.writeData(out);
        }
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        super.readInternal(in);
        int size = in.readInt();
        this.dataMap = new HashMap<Long, Data>(size);
        for (int i = 0; i < size; ++i) {
            long itemId = in.readLong();
            Data value = new Data();
            value.readData(in);
            this.dataMap.put(itemId, value);
        }
    }

    @Override
    public int getId() {
        return 5;
    }
}

