/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.spring.cache;

import com.hazelcast.core.DistributedObject;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.IMap;
import com.hazelcast.spring.cache.HazelcastCache;
import java.util.Collection;
import java.util.HashSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.springframework.cache.Cache;
import org.springframework.cache.CacheManager;

public class HazelcastCacheManager
implements CacheManager {
    private final ConcurrentMap<String, Cache> caches = new ConcurrentHashMap<String, Cache>();
    private HazelcastInstance hazelcastInstance;

    public HazelcastCacheManager() {
    }

    public HazelcastCacheManager(HazelcastInstance hazelcastInstance) {
        this.hazelcastInstance = hazelcastInstance;
    }

    public Cache getCache(String name) {
        IMap<Object, Object> map;
        Cache currentCache;
        Cache cache = (Cache)this.caches.get(name);
        if (cache == null && (currentCache = this.caches.putIfAbsent(name, cache = new HazelcastCache(map = this.hazelcastInstance.getMap(name)))) != null) {
            cache = currentCache;
        }
        return cache;
    }

    public Collection<String> getCacheNames() {
        HashSet<String> cacheNames = new HashSet<String>();
        Collection<DistributedObject> distributedObjects = this.hazelcastInstance.getDistributedObjects();
        for (DistributedObject distributedObject : distributedObjects) {
            if (!(distributedObject instanceof IMap)) continue;
            IMap map = (IMap)distributedObject;
            cacheNames.add(map.getName());
        }
        return cacheNames;
    }

    public void setHazelcastInstance(HazelcastInstance hazelcastInstance) {
        this.hazelcastInstance = hazelcastInstance;
    }
}

