/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.cache.impl;

import com.hazelcast.cache.impl.CacheDistributedObject;
import com.hazelcast.cache.impl.CacheEventDataImpl;
import com.hazelcast.cache.impl.CacheEventListener;
import com.hazelcast.cache.impl.CacheEventSet;
import com.hazelcast.cache.impl.CacheEventType;
import com.hazelcast.cache.impl.CacheMXBeanImpl;
import com.hazelcast.cache.impl.CacheOperationProvider;
import com.hazelcast.cache.impl.CachePartitionSegment;
import com.hazelcast.cache.impl.CacheStatisticsImpl;
import com.hazelcast.cache.impl.CacheStatisticsMXBeanImpl;
import com.hazelcast.cache.impl.DefaultOperationProvider;
import com.hazelcast.cache.impl.ICacheRecordStore;
import com.hazelcast.cache.impl.ICacheService;
import com.hazelcast.cache.impl.MXBeanUtil;
import com.hazelcast.cache.impl.operation.CacheCreateConfigOperation;
import com.hazelcast.cache.impl.operation.CacheDestroyOperation;
import com.hazelcast.config.CacheConfig;
import com.hazelcast.config.CacheSimpleConfig;
import com.hazelcast.config.InMemoryFormat;
import com.hazelcast.core.DistributedObject;
import com.hazelcast.instance.MemberImpl;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import com.hazelcast.partition.MigrationEndpoint;
import com.hazelcast.spi.EventRegistration;
import com.hazelcast.spi.EventService;
import com.hazelcast.spi.NodeEngine;
import com.hazelcast.spi.OperationService;
import com.hazelcast.spi.PartitionMigrationEvent;
import com.hazelcast.util.ConcurrencyUtil;
import com.hazelcast.util.ConstructorFunction;
import java.util.Collection;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public abstract class AbstractCacheService
implements ICacheService {
    protected final ConcurrentMap<String, CacheConfig> configs = new ConcurrentHashMap<String, CacheConfig>();
    protected final ConcurrentMap<String, CacheStatisticsImpl> statistics = new ConcurrentHashMap<String, CacheStatisticsImpl>();
    protected NodeEngine nodeEngine;
    protected CachePartitionSegment[] segments;
    private final ConcurrentMap<String, CacheOperationProvider> operationProviderCache = new ConcurrentHashMap<String, CacheOperationProvider>();
    private final ConstructorFunction<String, CacheStatisticsImpl> cacheStatisticsConstructorFunction = new ConstructorFunction<String, CacheStatisticsImpl>(){

        @Override
        public CacheStatisticsImpl createNew(String name) {
            return new CacheStatisticsImpl();
        }
    };

    @Override
    public final void init(NodeEngine nodeEngine, Properties properties) {
        this.nodeEngine = nodeEngine;
        int partitionCount = nodeEngine.getPartitionService().getPartitionCount();
        this.segments = new CachePartitionSegment[partitionCount];
        for (int i = 0; i < partitionCount; ++i) {
            this.segments[i] = new CachePartitionSegment(this, i);
        }
    }

    protected abstract ICacheRecordStore createNewRecordStore(String var1, int var2);

    @Override
    public DistributedObject createDistributedObject(String objectName) {
        return new CacheDistributedObject(objectName, this.nodeEngine, this);
    }

    @Override
    public void destroyDistributedObject(String objectName) {
    }

    @Override
    public void beforeMigration(PartitionMigrationEvent event) {
    }

    @Override
    public void commitMigration(PartitionMigrationEvent event) {
        if (event.getMigrationEndpoint() == MigrationEndpoint.SOURCE) {
            this.clearPartitionReplica(event.getPartitionId());
        }
    }

    @Override
    public void rollbackMigration(PartitionMigrationEvent event) {
        if (event.getMigrationEndpoint() == MigrationEndpoint.DESTINATION) {
            this.clearPartitionReplica(event.getPartitionId());
        }
    }

    @Override
    public void clearPartitionReplica(int partitionId) {
        this.segments[partitionId].clear();
    }

    @Override
    public ICacheRecordStore getOrCreateCache(String name, int partitionId) {
        return this.segments[partitionId].getOrCreateCache(name);
    }

    @Override
    public ICacheRecordStore getCacheRecordStore(String name, int partitionId) {
        return this.segments[partitionId].getCache(name);
    }

    @Override
    public CachePartitionSegment getSegment(int partitionId) {
        return this.segments[partitionId];
    }

    protected void destroySegments(String objectName) {
        for (CachePartitionSegment segment : this.segments) {
            segment.deleteCache(objectName);
        }
    }

    @Override
    public void destroyCache(String objectName, boolean isLocal, String callerUuid) {
        CacheConfig config = this.deleteCacheConfig(objectName);
        this.destroySegments(objectName);
        if (!isLocal) {
            this.deregisterAllListener(objectName);
        }
        this.operationProviderCache.remove(objectName);
        this.setStatisticsEnabled(config, objectName, false);
        this.setManagementEnabled(config, objectName, false);
        this.deleteCacheConfig(objectName);
        this.deleteCacheStat(objectName);
        if (!isLocal) {
            this.destroyCacheOnAllMembers(objectName, callerUuid);
        }
    }

    protected void destroyCacheOnAllMembers(String objectName, String callerUuid) {
        OperationService operationService = this.nodeEngine.getOperationService();
        Collection<MemberImpl> members = this.nodeEngine.getClusterService().getMemberList();
        for (MemberImpl member : members) {
            if (member.localMember() || member.getUuid().equals(callerUuid)) continue;
            CacheDestroyOperation op = new CacheDestroyOperation(objectName, true);
            operationService.invokeOnTarget("hz:impl:cacheService", op, member.getAddress());
        }
    }

    @Override
    public CacheConfig createCacheConfigIfAbsent(CacheConfig config, boolean isLocal) {
        CacheConfig localConfig = this.configs.putIfAbsent(config.getNameWithPrefix(), config);
        if (localConfig == null) {
            if (config.isStatisticsEnabled()) {
                this.setStatisticsEnabled(config, config.getNameWithPrefix(), true);
            }
            if (config.isManagementEnabled()) {
                this.setManagementEnabled(config, config.getNameWithPrefix(), true);
            }
            if (!isLocal) {
                this.createConfigOnAllMembers(config);
            }
        }
        return localConfig;
    }

    protected <K, V> void createConfigOnAllMembers(CacheConfig<K, V> cacheConfig) {
        OperationService operationService = this.nodeEngine.getOperationService();
        Collection<MemberImpl> members = this.nodeEngine.getClusterService().getMemberList();
        for (MemberImpl member : members) {
            if (member.localMember()) continue;
            CacheCreateConfigOperation op = new CacheCreateConfigOperation(cacheConfig, true);
            operationService.invokeOnTarget("hz:impl:cacheService", op, member.getAddress());
        }
    }

    @Override
    public CacheConfig deleteCacheConfig(String name) {
        return (CacheConfig)this.configs.remove(name);
    }

    @Override
    public CacheStatisticsImpl createCacheStatIfAbsent(String name) {
        return ConcurrencyUtil.getOrPutIfAbsent(this.statistics, name, this.cacheStatisticsConstructorFunction);
    }

    @Override
    public void deleteCacheStat(String name) {
        this.statistics.remove(name);
    }

    @Override
    public void setStatisticsEnabled(CacheConfig cacheConfig, String cacheNameWithPrefix, boolean enabled) {
        CacheConfig cacheConfig2 = cacheConfig = cacheConfig != null ? cacheConfig : (CacheConfig)this.configs.get(cacheNameWithPrefix);
        if (cacheConfig != null) {
            String cacheManagerName = cacheConfig.getUriString();
            cacheConfig.setStatisticsEnabled(enabled);
            if (enabled) {
                CacheStatisticsImpl cacheStatistics = this.createCacheStatIfAbsent(cacheNameWithPrefix);
                CacheStatisticsMXBeanImpl mxBean = new CacheStatisticsMXBeanImpl(cacheStatistics);
                MXBeanUtil.registerCacheObject(mxBean, cacheManagerName, cacheConfig.getName(), true);
            } else {
                MXBeanUtil.unregisterCacheObject(cacheManagerName, cacheConfig.getName(), true);
                this.deleteCacheStat(cacheNameWithPrefix);
            }
        }
    }

    @Override
    public void setManagementEnabled(CacheConfig cacheConfig, String cacheNameWithPrefix, boolean enabled) {
        CacheConfig cacheConfig2 = cacheConfig = cacheConfig != null ? cacheConfig : (CacheConfig)this.configs.get(cacheNameWithPrefix);
        if (cacheConfig != null) {
            String cacheManagerName = cacheConfig.getUriString();
            cacheConfig.setManagementEnabled(enabled);
            if (enabled) {
                CacheMXBeanImpl mxBean = new CacheMXBeanImpl(cacheConfig);
                MXBeanUtil.registerCacheObject(mxBean, cacheManagerName, cacheConfig.getName(), false);
            } else {
                MXBeanUtil.unregisterCacheObject(cacheManagerName, cacheConfig.getName(), false);
                this.deleteCacheStat(cacheNameWithPrefix);
            }
        }
    }

    @Override
    public CacheConfig getCacheConfig(String name) {
        return (CacheConfig)this.configs.get(name);
    }

    public CacheSimpleConfig findCacheConfig(String simpleName) {
        return this.nodeEngine.getConfig().findCacheConfig(simpleName);
    }

    @Override
    public Collection<CacheConfig> getCacheConfigs() {
        return this.configs.values();
    }

    public Object toObject(Object data) {
        if (data == null) {
            return null;
        }
        if (data instanceof Data) {
            return this.nodeEngine.toObject(data);
        }
        return data;
    }

    public Data toData(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof Data) {
            return (Data)object;
        }
        return this.nodeEngine.getSerializationService().toData(object);
    }

    @Override
    public void publishEvent(String cacheName, CacheEventType eventType, Data dataKey, Data dataValue, Data dataOldValue, boolean isOldValueAvailable, int orderKey) {
        IdentifiedDataSerializable eventData;
        EventService eventService = this.getNodeEngine().getEventService();
        Collection<EventRegistration> candidates = eventService.getRegistrations("hz:impl:cacheService", cacheName);
        if (candidates.isEmpty()) {
            return;
        }
        switch (eventType) {
            case CREATED: 
            case UPDATED: 
            case REMOVED: 
            case EXPIRED: {
                CacheEventDataImpl cacheEventData = new CacheEventDataImpl(cacheName, eventType, dataKey, dataValue, dataOldValue, isOldValueAvailable);
                CacheEventSet eventSet = new CacheEventSet(eventType);
                eventSet.addEventData(cacheEventData);
                eventData = eventSet;
                break;
            }
            case EVICTED: {
                eventData = new CacheEventDataImpl(cacheName, CacheEventType.EVICTED, dataKey, null, null, false);
                break;
            }
            case INVALIDATED: {
                eventData = new CacheEventDataImpl(cacheName, CacheEventType.INVALIDATED, dataKey, null, null, false);
                break;
            }
            case COMPLETED: {
                eventData = new CacheEventDataImpl(cacheName, CacheEventType.COMPLETED, dataKey, dataValue, null, false);
                break;
            }
            default: {
                throw new IllegalArgumentException("Event Type not defined to create an eventData during publish : " + eventType.name());
            }
        }
        this.nodeEngine.getEventService().publishEvent("hz:impl:cacheService", candidates, (Object)eventData, orderKey);
    }

    @Override
    public void publishEvent(String cacheName, CacheEventSet eventSet, int orderKey) {
        EventService eventService = this.getNodeEngine().getEventService();
        Collection<EventRegistration> candidates = eventService.getRegistrations("hz:impl:cacheService", cacheName);
        if (candidates.isEmpty()) {
            return;
        }
        this.nodeEngine.getEventService().publishEvent("hz:impl:cacheService", candidates, (Object)eventSet, orderKey);
    }

    @Override
    public NodeEngine getNodeEngine() {
        return this.nodeEngine;
    }

    @Override
    public void dispatchEvent(Object event, CacheEventListener listener) {
        listener.handleEvent(event);
    }

    @Override
    public String registerListener(String distributedObjectName, CacheEventListener listener) {
        EventService eventService = this.getNodeEngine().getEventService();
        EventRegistration registration = eventService.registerListener("hz:impl:cacheService", distributedObjectName, listener);
        return registration.getId();
    }

    @Override
    public boolean deregisterListener(String name, String registrationId) {
        EventService eventService = this.getNodeEngine().getEventService();
        return eventService.deregisterListener("hz:impl:cacheService", name, registrationId);
    }

    @Override
    public void deregisterAllListener(String name) {
        this.nodeEngine.getEventService().deregisterAllListeners("hz:impl:cacheService", name);
    }

    @Override
    public CacheStatisticsImpl getStatistics(String name) {
        return (CacheStatisticsImpl)this.statistics.get(name);
    }

    @Override
    public CacheOperationProvider getCacheOperationProvider(String nameWithPrefix, InMemoryFormat inMemoryFormat) {
        if (InMemoryFormat.NATIVE.equals((Object)inMemoryFormat)) {
            throw new IllegalArgumentException("Native memory is available only in Enterprise!");
        }
        CacheOperationProvider cacheOperationProvider = (CacheOperationProvider)this.operationProviderCache.get(nameWithPrefix);
        if (cacheOperationProvider != null) {
            return cacheOperationProvider;
        }
        cacheOperationProvider = new DefaultOperationProvider(nameWithPrefix);
        CacheOperationProvider current = this.operationProviderCache.putIfAbsent(nameWithPrefix, cacheOperationProvider);
        return current == null ? cacheOperationProvider : current;
    }
}

