/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.cache.impl;

import com.hazelcast.cache.ICache;
import com.hazelcast.config.CacheConfig;
import com.hazelcast.core.HazelcastInstance;
import java.lang.ref.WeakReference;
import java.net.URI;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.cache.CacheException;
import javax.cache.CacheManager;
import javax.cache.configuration.CacheEntryListenerConfiguration;
import javax.cache.configuration.CompleteConfiguration;
import javax.cache.configuration.Configuration;
import javax.cache.spi.CachingProvider;

public abstract class AbstractHazelcastCacheManager
implements CacheManager {
    protected final ConcurrentMap<String, ICache<?, ?>> caches = new ConcurrentHashMap();
    protected final URI uri;
    protected final WeakReference<ClassLoader> classLoaderReference;
    protected final Properties properties;
    protected final String cacheNamePrefix;
    protected final boolean isDefaultURI;
    protected final boolean isDefaultClassLoader;
    protected CachingProvider cachingProvider;
    protected HazelcastInstance hazelcastInstance;
    private final AtomicBoolean isClosed = new AtomicBoolean(false);
    private final AtomicBoolean isDestroyed = new AtomicBoolean(false);

    public AbstractHazelcastCacheManager(CachingProvider cachingProvider, URI uri, ClassLoader classLoader, Properties properties) {
        if (cachingProvider == null) {
            throw new NullPointerException("CachingProvider missing");
        }
        this.cachingProvider = cachingProvider;
        this.isDefaultURI = uri == null || cachingProvider.getDefaultURI().equals(uri);
        this.uri = this.isDefaultURI ? cachingProvider.getDefaultURI() : uri;
        this.isDefaultClassLoader = classLoader == null || cachingProvider.getDefaultClassLoader().equals(classLoader);
        ClassLoader localClassLoader = this.isDefaultClassLoader ? cachingProvider.getDefaultClassLoader() : classLoader;
        this.classLoaderReference = new WeakReference<ClassLoader>(localClassLoader);
        this.properties = properties == null ? new Properties() : new Properties(properties);
        this.cacheNamePrefix = this.cacheNamePrefix();
    }

    public <K, V, C extends Configuration<K, V>> ICache<K, V> createCache(String cacheName, C configuration) throws IllegalArgumentException {
        if (this.isClosed()) {
            throw new IllegalStateException();
        }
        if (cacheName == null) {
            throw new NullPointerException("cacheName must not be null");
        }
        if (configuration == null) {
            throw new NullPointerException("configuration must not be null");
        }
        CacheConfig<K, V> newCacheConfig = this.createCacheConfig(cacheName, configuration);
        ICache<K, V> cacheProxy = this.createCacheProxy(newCacheConfig);
        CacheConfig<K, V> current = this.createConfigOnPartition(newCacheConfig);
        if (current == null) {
            this.addCacheConfigIfAbsentToLocal(newCacheConfig);
            this.caches.put(newCacheConfig.getNameWithPrefix(), cacheProxy);
            this.registerListeners(newCacheConfig, cacheProxy);
            return cacheProxy;
        }
        ICache<?, ?> cache = this.getOrPutIfAbsent(current.getNameWithPrefix(), cacheProxy);
        CacheConfig config = (CacheConfig)cache.getConfiguration(CacheConfig.class);
        if (config.equals(configuration)) {
            return cache;
        }
        throw new CacheException("A cache named " + cacheName + " already exists.");
    }

    private ICache<?, ?> getOrPutIfAbsent(String nameWithPrefix, ICache cacheProxy) {
        ICache cache = (ICache)this.caches.get(nameWithPrefix);
        if (cache == null) {
            ICache iCache = this.caches.putIfAbsent(nameWithPrefix, cacheProxy);
            cache = iCache != null ? iCache : cacheProxy;
        }
        return cache;
    }

    public CachingProvider getCachingProvider() {
        return this.cachingProvider;
    }

    public URI getURI() {
        return this.uri;
    }

    public ClassLoader getClassLoader() {
        return (ClassLoader)this.classLoaderReference.get();
    }

    public Properties getProperties() {
        return this.properties;
    }

    public <K, V> ICache<K, V> getCache(String cacheName, Class<K> keyType, Class<V> valueType) {
        if (this.isClosed()) {
            throw new IllegalStateException();
        }
        if (keyType == null) {
            throw new NullPointerException("keyType can not be null");
        }
        if (valueType == null) {
            throw new NullPointerException("valueType can not be null");
        }
        ICache<?, ?> cache = this.getCacheUnchecked(cacheName);
        if (cache != null) {
            Configuration configuration = cache.getConfiguration(CacheConfig.class);
            if (configuration.getKeyType() != null && configuration.getKeyType().equals(keyType)) {
                if (configuration.getValueType() != null && configuration.getValueType().equals(valueType)) {
                    return cache;
                }
                throw new ClassCastException("Incompatible cache value types specified, expected " + configuration.getValueType() + " but " + valueType + " was specified");
            }
            throw new ClassCastException("Incompatible cache key types specified, expected " + configuration.getKeyType() + " but " + keyType + " was specified");
        }
        return null;
    }

    public <K, V> ICache<K, V> getCache(String cacheName) {
        if (this.isClosed()) {
            throw new IllegalStateException();
        }
        ICache<?, ?> cache = this.getCacheUnchecked(cacheName);
        if (cache != null) {
            Configuration configuration = cache.getConfiguration(CacheConfig.class);
            if (Object.class.equals((Object)configuration.getKeyType()) && Object.class.equals((Object)configuration.getValueType())) {
                return cache;
            }
            throw new IllegalArgumentException("Cache " + cacheName + " was " + "defined with specific types Cache<" + configuration.getKeyType() + ", " + configuration.getValueType() + "> " + "in which case CacheManager.getCache(String, Class, Class) must be used");
        }
        return null;
    }

    protected <K, V> ICache<?, ?> getCacheUnchecked(String cacheName) {
        String cacheNameWithPrefix = this.getCacheNameWithPrefix(cacheName);
        ICache<K, V> cache = (ICache<K, V>)this.caches.get(cacheNameWithPrefix);
        if (cache == null) {
            CacheConfig<K, V> cacheConfig = null;
            if (cacheConfig == null) {
                cacheConfig = this.getCacheConfigFromPartition(cacheNameWithPrefix, cacheName);
            }
            if (cacheConfig == null) {
                return null;
            }
            ICache<K, V> cacheProxy = this.createCacheProxy(cacheConfig);
            ICache<K, V> iCache = this.caches.putIfAbsent(cacheNameWithPrefix, cacheProxy);
            cache = iCache != null ? iCache : cacheProxy;
        }
        return cache;
    }

    public Iterable<String> getCacheNames() {
        Set names;
        if (this.isClosed()) {
            names = Collections.emptySet();
        } else {
            names = new LinkedHashSet();
            for (Map.Entry entry : this.caches.entrySet()) {
                if (((ICache)entry.getValue()).isClosed()) continue;
                String nameWithPrefix = (String)entry.getKey();
                int index = nameWithPrefix.indexOf(this.cacheNamePrefix) + this.cacheNamePrefix.length();
                String name = nameWithPrefix.substring(index);
                names.add(name);
            }
        }
        return Collections.unmodifiableCollection(names);
    }

    public void destroyCache(String cacheName) {
        if (this.isClosed()) {
            throw new IllegalStateException();
        }
        if (cacheName == null) {
            throw new NullPointerException();
        }
        String cacheNameWithPrefix = this.getCacheNameWithPrefix(cacheName);
        ICache cache = (ICache)this.caches.remove(cacheNameWithPrefix);
        if (cache != null) {
            cache.destroy();
        }
        this.removeCacheConfigFromLocal(cacheNameWithPrefix);
    }

    protected void removeCacheConfigFromLocal(String cacheName) {
    }

    public void close() {
        if (this.isDestroyed.get() || !this.isClosed.compareAndSet(false, true)) {
            return;
        }
        for (ICache cache : this.caches.values()) {
            cache.close();
        }
        this.postClose();
    }

    protected abstract void postClose();

    public void destroy() {
        if (!this.isDestroyed.compareAndSet(false, true)) {
            return;
        }
        this.isClosed.set(true);
        for (ICache cache : this.caches.values()) {
            cache.destroy();
        }
        this.caches.clear();
    }

    public boolean isClosed() {
        return this.isClosed.get() || !this.hazelcastInstance.getLifecycleService().isRunning();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("HazelcastCacheManager{");
        sb.append("hazelcastInstance=").append(this.hazelcastInstance);
        sb.append(", cachingProvider=").append(this.cachingProvider);
        sb.append('}');
        return sb.toString();
    }

    protected String cacheNamePrefix() {
        StringBuilder sb = new StringBuilder("/hz");
        if (!this.isDefaultURI) {
            sb.append("/").append(this.uri.toASCIIString());
        }
        ClassLoader classLoader = this.getClassLoader();
        if (!this.isDefaultClassLoader && classLoader != null) {
            sb.append("/").append(classLoader.toString());
        }
        sb.append("/");
        return sb.toString();
    }

    protected String getCacheNameWithPrefix(String name) {
        return this.cacheNamePrefix + name;
    }

    protected <K, V, C extends Configuration<K, V>> CacheConfig<K, V> createCacheConfig(String cacheName, C configuration) {
        CacheConfig cacheConfig;
        if (configuration instanceof CompleteConfiguration) {
            cacheConfig = new CacheConfig((CompleteConfiguration)configuration);
        } else {
            cacheConfig = new CacheConfig();
            cacheConfig.setStoreByValue(configuration.isStoreByValue());
            Class keyType = configuration.getKeyType();
            Class valueType = configuration.getValueType();
            cacheConfig.setTypes(keyType, valueType);
        }
        cacheConfig.setName(cacheName);
        cacheConfig.setManagerPrefix(this.cacheNamePrefix);
        cacheConfig.setUriString(this.getURI().toString());
        return cacheConfig;
    }

    protected abstract <K, V> CacheConfig<K, V> getCacheConfigLocal(String var1);

    protected abstract <K, V> CacheConfig<K, V> createConfigOnPartition(CacheConfig<K, V> var1);

    protected abstract <K, V> void addCacheConfigIfAbsentToLocal(CacheConfig<K, V> var1);

    protected abstract <K, V> ICache<K, V> createCacheProxy(CacheConfig<K, V> var1);

    protected abstract <K, V> CacheConfig<K, V> getCacheConfigFromPartition(String var1, String var2);

    protected <K, V> void registerListeners(CacheConfig<K, V> cacheConfig, ICache<K, V> source) {
        Iterator iterator = cacheConfig.getCacheEntryListenerConfigurations().iterator();
        while (iterator.hasNext()) {
            CacheEntryListenerConfiguration listenerConfig = (CacheEntryListenerConfiguration)iterator.next();
            iterator.remove();
            source.registerCacheEntryListener(listenerConfig);
        }
    }
}

