/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.cache.impl;

import com.hazelcast.cache.impl.AbstractCacheRecordStore;
import com.hazelcast.cache.impl.CacheStatisticsImpl;
import com.hazelcast.cache.impl.record.CacheRecord;
import com.hazelcast.nio.serialization.Data;
import javax.cache.configuration.Factory;
import javax.cache.expiry.ExpiryPolicy;
import javax.cache.processor.MutableEntry;

public class CacheEntryProcessorEntry<K, V, R extends CacheRecord>
implements MutableEntry<K, V> {
    protected K key;
    protected V value;
    protected State state = State.NONE;
    protected final Data keyData;
    protected R record;
    protected R recordLoaded;
    protected final AbstractCacheRecordStore cacheRecordStore;
    protected final long now;
    protected final long start;
    protected final ExpiryPolicy expiryPolicy;

    public CacheEntryProcessorEntry(Data keyData, R record, AbstractCacheRecordStore cacheRecordStore, long now) {
        this.keyData = keyData;
        this.record = record;
        this.cacheRecordStore = cacheRecordStore;
        this.now = now;
        this.start = cacheRecordStore.cacheConfig.isStatisticsEnabled() ? System.nanoTime() : 0L;
        Factory expiryPolicyFactory = cacheRecordStore.cacheConfig.getExpiryPolicyFactory();
        this.expiryPolicy = (ExpiryPolicy)expiryPolicyFactory.create();
    }

    public boolean exists() {
        return this.record != null && this.state == State.NONE || this.value != null;
    }

    public void remove() {
        this.value = null;
        this.state = this.state == State.CREATE || this.state == State.LOAD ? State.NONE : State.REMOVE;
    }

    public void setValue(V value) {
        if (value == null) {
            throw new NullPointerException("Null value not allowed");
        }
        this.state = this.record == null ? State.CREATE : State.UPDATE;
        this.value = value;
    }

    public K getKey() {
        if (this.key == null) {
            this.key = this.cacheRecordStore.cacheService.toObject(this.keyData);
        }
        return this.key;
    }

    public V getValue() {
        if (this.state == State.REMOVE) {
            return null;
        }
        if (this.value != null) {
            return this.value;
        }
        if (this.record != null) {
            this.state = State.ACCESS;
            return this.getRecordValue(this.record);
        }
        if (this.recordLoaded == null) {
            this.recordLoaded = this.cacheRecordStore.readThroughRecord(this.keyData, this.now);
        }
        if (this.recordLoaded != null) {
            this.state = State.LOAD;
            return this.getRecordValue(this.recordLoaded);
        }
        return null;
    }

    protected V getRecordValue(R record) {
        Object objValue;
        switch (this.cacheRecordStore.cacheConfig.getInMemoryFormat()) {
            case BINARY: {
                objValue = this.cacheRecordStore.cacheService.toObject(record.getValue());
                break;
            }
            case OBJECT: {
                objValue = record.getValue();
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid storage format: " + (Object)((Object)this.cacheRecordStore.cacheConfig.getInMemoryFormat()));
            }
        }
        return objValue;
    }

    public void applyChanges() {
        boolean isStatisticsEnabled = this.cacheRecordStore.cacheConfig.isStatisticsEnabled();
        CacheStatisticsImpl statistics = this.cacheRecordStore.statistics;
        switch (this.state) {
            case ACCESS: {
                this.cacheRecordStore.accessRecord(this.record, this.expiryPolicy, this.now);
                break;
            }
            case UPDATE: {
                this.cacheRecordStore.updateRecordWithExpiry(this.keyData, this.value, this.record, this.expiryPolicy, this.now, false);
                if (!isStatisticsEnabled) break;
                statistics.increaseCachePuts(1L);
                statistics.addGetTimeNanos(System.nanoTime() - this.start);
                break;
            }
            case REMOVE: {
                this.cacheRecordStore.remove(this.keyData, null);
                break;
            }
            case CREATE: {
                if (isStatisticsEnabled) {
                    statistics.increaseCachePuts(1L);
                    statistics.addGetTimeNanos(System.nanoTime() - this.start);
                }
                this.cacheRecordStore.createRecordWithExpiry(this.keyData, this.value, this.expiryPolicy, this.now, false);
                break;
            }
            case LOAD: {
                this.cacheRecordStore.createRecordWithExpiry(this.keyData, this.value, this.expiryPolicy, this.now, true);
                break;
            }
            case NONE: {
                break;
            }
        }
    }

    public <T> T unwrap(Class<T> clazz) {
        if (clazz.isAssignableFrom(this.getClass())) {
            return clazz.cast(this);
        }
        throw new IllegalArgumentException("Unwrapping to " + clazz + " is not supported by this implementation");
    }

    protected static enum State {
        NONE,
        ACCESS,
        UPDATE,
        LOAD,
        CREATE,
        REMOVE;

    }
}

