/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.cache.impl;

import com.hazelcast.cache.impl.AbstractCacheRecordStore;
import com.hazelcast.cache.impl.AbstractCacheService;
import com.hazelcast.cache.impl.CacheEntryProcessorEntry;
import com.hazelcast.cache.impl.record.CacheRecord;
import com.hazelcast.cache.impl.record.CacheRecordFactory;
import com.hazelcast.cache.impl.record.CacheRecordHashMap;
import com.hazelcast.nio.IOUtil;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.nio.serialization.SerializationService;
import com.hazelcast.spi.EventRegistration;
import com.hazelcast.spi.EventService;
import com.hazelcast.spi.NodeEngine;
import com.hazelcast.spi.impl.EventServiceImpl;
import com.hazelcast.util.EmptyStatement;
import java.io.Closeable;
import java.io.IOException;
import java.util.Collection;

public class CacheRecordStore
extends AbstractCacheRecordStore<CacheRecord, CacheRecordHashMap<Data, CacheRecord>> {
    protected SerializationService serializationService;
    protected CacheRecordFactory cacheRecordFactory;

    public CacheRecordStore(String name, int partitionId, NodeEngine nodeEngine, AbstractCacheService cacheService) {
        super(name, partitionId, nodeEngine, cacheService);
        this.serializationService = nodeEngine.getSerializationService();
        this.records = this.createRecordCacheMap();
        this.cacheRecordFactory = this.createCacheRecordFactory();
    }

    @Override
    protected CacheRecordHashMap createRecordCacheMap() {
        return new CacheRecordHashMap(1000);
    }

    @Override
    protected CacheEntryProcessorEntry createCacheEntryProcessorEntry(Data key, CacheRecord record, long now) {
        return new CacheEntryProcessorEntry(key, record, this, now);
    }

    protected CacheRecordFactory createCacheRecordFactory() {
        return new CacheRecordFactory(this.cacheConfig.getInMemoryFormat(), this.nodeEngine.getSerializationService());
    }

    @Override
    protected <T> CacheRecord createRecord(T value, long creationTime, long expiryTime) {
        this.evictIfRequired();
        return this.cacheRecordFactory.newRecordWithExpiry(value, expiryTime);
    }

    @Override
    protected <T> Data valueToData(T value) {
        return this.cacheService.toData(value);
    }

    @Override
    protected <T> T dataToValue(Data data) {
        return this.serializationService.toObject(data);
    }

    @Override
    protected <T> CacheRecord valueToRecord(T value) {
        return this.cacheRecordFactory.newRecord(value);
    }

    @Override
    protected <T> T recordToValue(CacheRecord record) {
        Object value = record.getValue();
        if (value instanceof Data) {
            return this.dataToValue((Data)value);
        }
        return (T)value;
    }

    @Override
    protected Data recordToData(CacheRecord record) {
        Object value = this.recordToValue(record);
        if (value == null) {
            return null;
        }
        if (value instanceof Data) {
            return (Data)value;
        }
        return this.valueToData(value);
    }

    @Override
    protected CacheRecord dataToRecord(Data data) {
        Object value = this.dataToValue(data);
        if (value == null) {
            return null;
        }
        if (value instanceof CacheRecord) {
            return (CacheRecord)value;
        }
        return this.valueToRecord(value);
    }

    @Override
    protected Data toHeapData(Object obj) {
        if (obj == null) {
            return null;
        }
        if (obj instanceof Data) {
            return (Data)obj;
        }
        if (obj instanceof CacheRecord) {
            CacheRecord record = (CacheRecord)obj;
            Object value = record.getValue();
            return this.toHeapData(value);
        }
        return this.serializationService.toData(obj);
    }

    @Override
    protected boolean isEvictionRequired() {
        return false;
    }

    @Override
    public void destroy() {
        this.clear();
        this.closeResources();
        EventService eventService = this.cacheService.getNodeEngine().getEventService();
        Collection<EventRegistration> candidates = eventService.getRegistrations("hz:impl:cacheService", this.name);
        for (EventRegistration registration : candidates) {
            if (!(((EventServiceImpl.Registration)registration).getListener() instanceof Closeable)) continue;
            try {
                ((Closeable)((Object)registration)).close();
            }
            catch (IOException e) {
                EmptyStatement.ignore(e);
            }
        }
    }

    protected void closeResources() {
        if (this.cacheWriter instanceof Closeable) {
            IOUtil.closeResource((Closeable)this.cacheWriter);
        }
        if (this.cacheLoader instanceof Closeable) {
            IOUtil.closeResource((Closeable)this.cacheLoader);
        }
        if (this.defaultExpiryPolicy instanceof Closeable) {
            IOUtil.closeResource((Closeable)this.defaultExpiryPolicy);
        }
    }
}

