/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.cache.impl;

import com.hazelcast.cache.ICache;
import com.hazelcast.cache.impl.AbstractHazelcastCacheManager;
import com.hazelcast.cache.impl.CacheDistributedObject;
import com.hazelcast.cache.impl.CacheProxy;
import com.hazelcast.cache.impl.HazelcastServerCachingProvider;
import com.hazelcast.cache.impl.ICacheService;
import com.hazelcast.cache.impl.operation.CacheCreateConfigOperation;
import com.hazelcast.cache.impl.operation.CacheGetConfigOperation;
import com.hazelcast.cache.impl.operation.CacheManagementConfigOperation;
import com.hazelcast.config.CacheConfig;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.instance.MemberImpl;
import com.hazelcast.spi.InternalCompletableFuture;
import com.hazelcast.spi.NodeEngine;
import com.hazelcast.spi.OperationService;
import com.hazelcast.spi.impl.NodeEngineImpl;
import com.hazelcast.util.FutureUtil;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Properties;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;

public class HazelcastServerCacheManager
extends AbstractHazelcastCacheManager {
    private final NodeEngine nodeEngine;
    private final ICacheService cacheService;

    public HazelcastServerCacheManager(HazelcastServerCachingProvider cachingProvider, HazelcastInstance hazelcastInstance, URI uri, ClassLoader classLoader, Properties properties) {
        super(cachingProvider, uri, classLoader, properties);
        if (hazelcastInstance == null) {
            throw new NullPointerException("hazelcastInstance missing");
        }
        this.hazelcastInstance = hazelcastInstance;
        CacheDistributedObject setupRef = (CacheDistributedObject)hazelcastInstance.getDistributedObject("hz:impl:cacheService", "setupRef");
        this.nodeEngine = (NodeEngineImpl)setupRef.getNodeEngine();
        this.cacheService = (ICacheService)setupRef.getService();
    }

    public void enableManagement(String cacheName, boolean enabled) {
        if (this.isClosed()) {
            throw new IllegalStateException();
        }
        if (cacheName == null) {
            throw new NullPointerException();
        }
        String cacheNameWithPrefix = this.getCacheNameWithPrefix(cacheName);
        this.cacheService.setManagementEnabled(null, cacheNameWithPrefix, enabled);
        this.enableStatisticManagementOnOtherNodes(cacheName, false, enabled);
    }

    public void enableStatistics(String cacheName, boolean enabled) {
        if (this.isClosed()) {
            throw new IllegalStateException();
        }
        if (cacheName == null) {
            throw new NullPointerException();
        }
        String cacheNameWithPrefix = this.getCacheNameWithPrefix(cacheName);
        this.cacheService.setStatisticsEnabled(null, cacheNameWithPrefix, enabled);
        this.enableStatisticManagementOnOtherNodes(cacheName, true, enabled);
    }

    private void enableStatisticManagementOnOtherNodes(String cacheName, boolean statOrMan, boolean enabled) {
        String cacheNameWithPrefix = this.getCacheNameWithPrefix(cacheName);
        Collection<MemberImpl> members = this.nodeEngine.getClusterService().getMemberList();
        ArrayList<Future> futures = new ArrayList<Future>();
        for (MemberImpl member : members) {
            if (member.localMember()) continue;
            CacheManagementConfigOperation op = new CacheManagementConfigOperation(cacheNameWithPrefix, statOrMan, enabled);
            InternalCompletableFuture future = this.nodeEngine.getOperationService().invokeOnTarget("hz:impl:cacheService", op, member.getAddress());
            futures.add(future);
        }
        FutureUtil.waitWithDeadline(futures, 60L, TimeUnit.SECONDS);
    }

    @Override
    protected <K, V> CacheConfig<K, V> getCacheConfigLocal(String cacheName) {
        return this.cacheService.getCacheConfig(cacheName);
    }

    @Override
    protected <K, V> CacheConfig<K, V> createConfigOnPartition(CacheConfig<K, V> cacheConfig) {
        CacheCreateConfigOperation cacheCreateConfigOperation = new CacheCreateConfigOperation(cacheConfig);
        OperationService operationService = this.nodeEngine.getOperationService();
        int partitionId = this.nodeEngine.getPartitionService().getPartitionId(cacheConfig.getNameWithPrefix());
        InternalCompletableFuture f = operationService.invokeOnPartition("hz:impl:cacheService", cacheCreateConfigOperation, partitionId);
        return (CacheConfig)f.getSafely();
    }

    @Override
    protected <K, V> void addCacheConfigIfAbsentToLocal(CacheConfig<K, V> cacheConfig) {
        this.cacheService.createCacheConfigIfAbsent(cacheConfig, false);
    }

    @Override
    protected <K, V> ICache<K, V> createCacheProxy(CacheConfig<K, V> cacheConfig) {
        return new CacheProxy(cacheConfig, this.nodeEngine, this.cacheService, this);
    }

    @Override
    protected <K, V> CacheConfig<K, V> getCacheConfigFromPartition(String cacheNameWithPrefix, String cacheName) {
        CacheGetConfigOperation op = new CacheGetConfigOperation(cacheNameWithPrefix, cacheName);
        int partitionId = this.nodeEngine.getPartitionService().getPartitionId(cacheNameWithPrefix);
        InternalCompletableFuture f = this.nodeEngine.getOperationService().invokeOnPartition("hz:impl:cacheService", op, partitionId);
        return (CacheConfig)f.getSafely();
    }

    @Override
    protected void removeCacheConfigFromLocal(String cacheName) {
        this.cacheService.deleteCacheConfig(cacheName);
        super.removeCacheConfigFromLocal(cacheName);
    }

    public <T> T unwrap(Class<T> clazz) {
        if (HazelcastServerCacheManager.class.isAssignableFrom(clazz)) {
            return (T)this;
        }
        throw new IllegalArgumentException();
    }

    @Override
    protected void postClose() {
        if (this.properties.getProperty("hazelcast.config.location") != null) {
            this.hazelcastInstance.shutdown();
        }
    }
}

