/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.cache.impl.operation;

import com.hazelcast.cache.impl.CacheClearResponse;
import com.hazelcast.cache.impl.ICacheRecordStore;
import com.hazelcast.cache.impl.ICacheService;
import com.hazelcast.cache.impl.operation.CacheRemoveAllBackupOperation;
import com.hazelcast.cache.impl.operation.PartitionWideCacheOperation;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.nio.serialization.DefaultData;
import com.hazelcast.partition.InternalPartitionService;
import com.hazelcast.spi.BackupAwareOperation;
import com.hazelcast.spi.Operation;
import java.util.HashSet;
import java.util.Set;
import javax.cache.CacheException;

public class CacheRemoveAllOperation
extends PartitionWideCacheOperation
implements BackupAwareOperation {
    private Set<Data> keys;
    private int completionId;
    private transient Set<Data> filteredKeys = new HashSet<Data>();
    private transient ICacheRecordStore cache;

    public CacheRemoveAllOperation() {
    }

    public CacheRemoveAllOperation(String name, Set<Data> keys, int completionId) {
        super(name);
        this.keys = keys;
        this.completionId = completionId;
    }

    @Override
    public boolean shouldBackup() {
        return !this.filteredKeys.isEmpty();
    }

    @Override
    public final int getSyncBackupCount() {
        return this.cache != null ? this.cache.getConfig().getBackupCount() : 0;
    }

    @Override
    public final int getAsyncBackupCount() {
        return this.cache != null ? this.cache.getConfig().getAsyncBackupCount() : 0;
    }

    @Override
    public Operation getBackupOperation() {
        return new CacheRemoveAllBackupOperation(this.name, this.filteredKeys);
    }

    @Override
    public int getId() {
        return 34;
    }

    @Override
    public void beforeRun() throws Exception {
        ICacheService service = (ICacheService)this.getService();
        this.cache = service.getCacheRecordStore(this.name, this.getPartitionId());
    }

    @Override
    public void run() throws Exception {
        if (this.cache == null) {
            return;
        }
        this.filterKeys();
        try {
            if (this.keys == null) {
                this.cache.removeAll(this.filteredKeys);
            } else if (!this.filteredKeys.isEmpty()) {
                this.cache.removeAll(this.filteredKeys);
            }
            this.response = new CacheClearResponse(Boolean.TRUE);
            int orderKey = this.keys != null ? this.keys.hashCode() : 1;
            this.cache.publishCompletedEvent(this.name, this.completionId, new DefaultData(), orderKey);
        }
        catch (CacheException e) {
            this.response = new CacheClearResponse((Object)e);
        }
    }

    private void filterKeys() {
        if (this.keys == null) {
            return;
        }
        InternalPartitionService partitionService = this.getNodeEngine().getPartitionService();
        for (Data k : this.keys) {
            if (partitionService.getPartitionId(k) != this.getPartitionId()) continue;
            this.filteredKeys.add(k);
        }
    }
}

