/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.cache.impl.record;

import com.hazelcast.cache.impl.record.CacheDataRecord;
import com.hazelcast.cache.impl.record.CacheObjectRecord;
import com.hazelcast.cache.impl.record.CacheRecord;
import com.hazelcast.config.InMemoryFormat;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.nio.serialization.SerializationService;

public class CacheRecordFactory<R extends CacheRecord> {
    protected InMemoryFormat inMemoryFormat;
    protected SerializationService serializationService;

    public CacheRecordFactory(InMemoryFormat inMemoryFormat, SerializationService serializationService) {
        this.inMemoryFormat = inMemoryFormat;
        this.serializationService = serializationService;
    }

    public R newRecord(Object value) {
        return this.newRecordWithExpiry(value, -1L);
    }

    public R newRecordWithExpiry(Object value, long expiryTime) {
        CacheRecord record;
        switch (this.inMemoryFormat) {
            case BINARY: {
                Object dataValue = this.serializationService.toData(value);
                record = this.createCacheDataRecord((Data)dataValue, expiryTime);
                break;
            }
            case OBJECT: {
                Object objectValue = this.serializationService.toObject(value);
                record = this.createCacheObjectRecord(objectValue, expiryTime);
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid storage format: " + (Object)((Object)this.inMemoryFormat));
            }
        }
        return (R)record;
    }

    protected CacheRecord createCacheDataRecord(Data dataValue, long expiryTime) {
        return new CacheDataRecord(dataValue, expiryTime);
    }

    protected CacheRecord createCacheObjectRecord(Object objectValue, long expiryTime) {
        return new CacheObjectRecord(objectValue, expiryTime);
    }

    public static boolean isExpiredAt(long expirationTime, long now) {
        return expirationTime > -1L && expirationTime <= now;
    }
}

