/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.cache.impl.record;

import com.hazelcast.cache.impl.CacheKeyIteratorResult;
import com.hazelcast.cache.impl.record.CacheRecordMap;
import com.hazelcast.cache.impl.record.Expirable;
import com.hazelcast.config.EvictionPolicy;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.spi.Callback;
import com.hazelcast.util.Clock;
import com.hazelcast.util.ConcurrentReferenceHashMap;
import com.hazelcast.util.EmptyStatement;
import com.hazelcast.util.FetchableConcurrentHashMap;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.Map;

public class CacheRecordHashMap<K, V>
extends FetchableConcurrentHashMap<K, V>
implements CacheRecordMap<K, V> {
    private static final int MIN_EVICTION_ELEMENT_COUNT = 100;
    private Callback<Data> evictionCallback;

    public CacheRecordHashMap(int initialCapacity) {
        super(initialCapacity);
    }

    public CacheRecordHashMap(int initialCapacity, float loadFactor, int concurrencyLevel, ConcurrentReferenceHashMap.ReferenceType keyType, ConcurrentReferenceHashMap.ReferenceType valueType, EnumSet<ConcurrentReferenceHashMap.Option> options) {
        this(initialCapacity, loadFactor, concurrencyLevel, keyType, valueType, options, null);
    }

    public CacheRecordHashMap(int initialCapacity, float loadFactor, int concurrencyLevel, ConcurrentReferenceHashMap.ReferenceType keyType, ConcurrentReferenceHashMap.ReferenceType valueType, EnumSet<ConcurrentReferenceHashMap.Option> options, Callback<Data> evictionCallback) {
        super(initialCapacity, loadFactor, concurrencyLevel, keyType, valueType, options);
        this.evictionCallback = evictionCallback;
    }

    @Override
    public CacheKeyIteratorResult fetchNext(int nextTableIndex, int size) {
        ArrayList<Data> keys = new ArrayList<Data>();
        int tableIndex = this.fetch(nextTableIndex, size, keys);
        return new CacheKeyIteratorResult(keys, tableIndex);
    }

    private void callbackEvictionListeners(Data data) {
        if (this.evictionCallback != null) {
            this.evictionCallback.notify(data);
        }
    }

    @Override
    public int evictExpiredRecords(int percentage) {
        long now = Clock.currentTimeMillis();
        int sizeLimitForEviction = (int)((double)(this.size() * percentage) / 100.0);
        if (sizeLimitForEviction < 100) {
            return 0;
        }
        ArrayList expiredEntries = new ArrayList(sizeLimitForEviction);
        int expiredCount = 0;
        for (Map.Entry entry : this.entrySet()) {
            Object k = entry.getKey();
            Object value = entry.getValue();
            boolean isExpired = value instanceof Expirable && ((Expirable)value).isExpiredAt(now);
            if (!isExpired) continue;
            expiredEntries.add(entry);
            if (++expiredCount < sizeLimitForEviction) continue;
            break;
        }
        int actualExpiredCount = 0;
        for (Map.Entry entry : expiredEntries) {
            Expirable expirableValue = (Expirable)entry.getValue();
            if (expirableValue instanceof Data) {
                this.callbackEvictionListeners((Data)((Object)expirableValue));
            }
            if (this.remove(entry.getKey()) == null) continue;
            ++actualExpiredCount;
        }
        return actualExpiredCount;
    }

    @Override
    public int evictRecords(int percentage, EvictionPolicy policy) {
        switch (policy) {
            case RANDOM: {
                try {
                    return this.evictRecordsRandom(percentage);
                }
                catch (Throwable e) {
                    EmptyStatement.ignore(e);
                    break;
                }
            }
            case LRU: {
                try {
                    return this.evictRecordsLRU(percentage);
                }
                catch (Throwable e) {
                    EmptyStatement.ignore(e);
                    break;
                }
            }
            case LFU: {
                try {
                    return this.evictRecordsLFU(percentage);
                }
                catch (Throwable e) {
                    EmptyStatement.ignore(e);
                    break;
                }
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        return this.evictExpiredRecords(percentage);
    }

    private int evictRecordsLRU(int percentage) {
        throw new UnsupportedOperationException("\"LRU\" eviction is not supported right now !");
    }

    private int evictRecordsLFU(int percentage) {
        throw new UnsupportedOperationException("\"LFU\" eviction is not supported right now !");
    }

    private int evictRecordsRandom(int percentage) {
        int sizeLimitForEviction = (int)((double)(this.size() * percentage) / 100.0);
        if (sizeLimitForEviction < 100) {
            return 0;
        }
        ArrayList expiredEntries = new ArrayList(sizeLimitForEviction);
        int expiredCount = 0;
        for (Map.Entry entry : this.entrySet()) {
            expiredEntries.add(entry);
            if (++expiredCount < sizeLimitForEviction) continue;
            break;
        }
        int actualExpiredCount = 0;
        for (Map.Entry entry : expiredEntries) {
            Object value = entry.getValue();
            if (value instanceof Data) {
                this.callbackEvictionListeners((Data)value);
            }
            if (this.remove(entry.getKey()) == null) continue;
            ++actualExpiredCount;
        }
        return actualExpiredCount;
    }
}

