/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.config;

import com.hazelcast.config.AbstractCacheConfig;
import com.hazelcast.config.CacheConfigReadOnly;
import com.hazelcast.config.CacheSimpleConfig;
import com.hazelcast.config.CacheSimpleEntryListenerConfig;
import com.hazelcast.config.EvictionPolicy;
import com.hazelcast.config.InMemoryFormat;
import com.hazelcast.config.NearCacheConfig;
import com.hazelcast.nio.ClassLoaderUtil;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.util.ValidationUtil;
import java.io.IOException;
import javax.cache.configuration.CacheEntryListenerConfiguration;
import javax.cache.configuration.CompleteConfiguration;
import javax.cache.configuration.Factory;
import javax.cache.configuration.FactoryBuilder;
import javax.cache.configuration.MutableCacheEntryListenerConfiguration;

public class CacheConfig<K, V>
extends AbstractCacheConfig<K, V> {
    private String name;
    private String managerPrefix;
    private String uriString;
    private int asyncBackupCount = 0;
    private int backupCount = 1;
    private InMemoryFormat inMemoryFormat = CacheSimpleConfig.DEFAULT_IN_MEMORY_FORMAT;
    private EvictionPolicy evictionPolicy = CacheSimpleConfig.DEFAULT_EVICTION_POLICY;
    private int evictionPercentage = 10;
    private int evictionThresholdPercentage = 95;
    private NearCacheConfig nearCacheConfig;

    public CacheConfig() {
    }

    public CacheConfig(CompleteConfiguration<K, V> configuration) {
        super(configuration);
        if (configuration instanceof CacheConfig) {
            CacheConfig config = (CacheConfig)configuration;
            this.name = config.name;
            this.managerPrefix = config.managerPrefix;
            this.uriString = config.uriString;
            this.asyncBackupCount = config.asyncBackupCount;
            this.backupCount = config.backupCount;
            this.inMemoryFormat = config.inMemoryFormat;
            this.evictionPolicy = config.evictionPolicy;
            if (config.nearCacheConfig != null) {
                this.nearCacheConfig = new NearCacheConfig(config.nearCacheConfig);
            }
        }
    }

    public CacheConfig(CacheSimpleConfig simpleConfig) throws Exception {
        this.name = simpleConfig.getName();
        if (simpleConfig.getKeyType() != null) {
            this.keyType = ClassLoaderUtil.loadClass(null, simpleConfig.getKeyType());
        }
        if (simpleConfig.getValueType() != null) {
            this.valueType = ClassLoaderUtil.loadClass(null, simpleConfig.getValueType());
        }
        this.isStatisticsEnabled = simpleConfig.isStatisticsEnabled();
        this.isManagementEnabled = simpleConfig.isManagementEnabled();
        this.isReadThrough = simpleConfig.isReadThrough();
        this.isWriteThrough = simpleConfig.isWriteThrough();
        if (simpleConfig.getCacheLoaderFactory() != null) {
            this.cacheLoaderFactory = (Factory)ClassLoaderUtil.newInstance(null, simpleConfig.getCacheLoaderFactory());
        }
        if (simpleConfig.getCacheWriterFactory() != null) {
            this.cacheLoaderFactory = (Factory)ClassLoaderUtil.newInstance(null, simpleConfig.getCacheWriterFactory());
        }
        if (simpleConfig.getExpiryPolicyFactory() != null) {
            this.cacheLoaderFactory = (Factory)ClassLoaderUtil.newInstance(null, simpleConfig.getExpiryPolicyFactory());
        }
        this.asyncBackupCount = simpleConfig.getAsyncBackupCount();
        this.backupCount = simpleConfig.getBackupCount();
        this.inMemoryFormat = simpleConfig.getInMemoryFormat();
        this.evictionPolicy = simpleConfig.getEvictionPolicy();
        this.evictionPercentage = simpleConfig.getEvictionPercentage();
        this.evictionThresholdPercentage = simpleConfig.getEvictionThresholdPercentage();
        for (CacheSimpleEntryListenerConfig simpleListener : simpleConfig.getCacheEntryListeners()) {
            Factory listenerFactory = null;
            Factory filterFactory = null;
            if (simpleListener.getCacheEntryListenerFactory() != null) {
                listenerFactory = FactoryBuilder.factoryOf((String)simpleListener.getCacheEntryListenerFactory());
            }
            if (simpleListener.getCacheEntryEventFilterFactory() != null) {
                filterFactory = FactoryBuilder.factoryOf((String)simpleListener.getCacheEntryEventFilterFactory());
            }
            boolean isOldValueRequired = simpleListener.isOldValueRequired();
            boolean synchronous = simpleListener.isSynchronous();
            MutableCacheEntryListenerConfiguration listenerConfiguration = new MutableCacheEntryListenerConfiguration(listenerFactory, filterFactory, isOldValueRequired, synchronous);
            this.addCacheEntryListenerConfiguration((CacheEntryListenerConfiguration)listenerConfiguration);
        }
    }

    public CacheConfigReadOnly<K, V> getAsReadOnly() {
        return new CacheConfigReadOnly(this);
    }

    public String getName() {
        return this.name;
    }

    public CacheConfig<K, V> setName(String name) {
        this.name = name;
        return this;
    }

    public String getManagerPrefix() {
        return this.managerPrefix;
    }

    public CacheConfig<K, V> setManagerPrefix(String managerPrefix) {
        this.managerPrefix = managerPrefix;
        return this;
    }

    public String getUriString() {
        return this.uriString;
    }

    public CacheConfig<K, V> setUriString(String uriString) {
        this.uriString = uriString;
        return this;
    }

    public String getNameWithPrefix() {
        return this.managerPrefix + this.name;
    }

    public int getBackupCount() {
        return this.backupCount;
    }

    public CacheConfig<K, V> setBackupCount(int backupCount) {
        if (backupCount < 0) {
            throw new IllegalArgumentException("map backup count must be equal to or bigger than 0");
        }
        if (backupCount + this.asyncBackupCount > 6) {
            throw new IllegalArgumentException("total (sync + async) map backup count must be less than 6");
        }
        this.backupCount = backupCount;
        return this;
    }

    public int getAsyncBackupCount() {
        return this.asyncBackupCount;
    }

    public CacheConfig<K, V> setAsyncBackupCount(int asyncBackupCount) {
        if (asyncBackupCount < 0) {
            throw new IllegalArgumentException("map async backup count must be equal to or bigger than 0");
        }
        if (this.backupCount + asyncBackupCount > 6) {
            throw new IllegalArgumentException("total (sync + async) map backup count must be less than 6");
        }
        this.asyncBackupCount = asyncBackupCount;
        return this;
    }

    public int getTotalBackupCount() {
        return this.backupCount + this.asyncBackupCount;
    }

    public EvictionPolicy getEvictionPolicy() {
        return this.evictionPolicy;
    }

    public CacheConfig<K, V> setEvictionPolicy(EvictionPolicy evictionPolicy) {
        this.evictionPolicy = evictionPolicy;
        return this;
    }

    public NearCacheConfig getNearCacheConfig() {
        return this.nearCacheConfig;
    }

    public CacheConfig setNearCacheConfig(NearCacheConfig nearCacheConfig) {
        this.nearCacheConfig = nearCacheConfig;
        return this;
    }

    public InMemoryFormat getInMemoryFormat() {
        return this.inMemoryFormat;
    }

    public CacheConfig<K, V> setInMemoryFormat(InMemoryFormat inMemoryFormat) {
        this.inMemoryFormat = ValidationUtil.isNotNull(inMemoryFormat, "inMemoryFormat");
        return this;
    }

    public int getEvictionPercentage() {
        return this.evictionPercentage;
    }

    public CacheConfig<K, V> setEvictionPercentage(int evictionPercentage) {
        this.evictionPercentage = evictionPercentage;
        return this;
    }

    public int getEvictionThresholdPercentage() {
        return this.evictionThresholdPercentage;
    }

    public CacheConfig<K, V> setEvictionThresholdPercentage(int evictionThresholdPercentage) {
        this.evictionThresholdPercentage = evictionThresholdPercentage;
        return this;
    }

    @Override
    public void writeData(ObjectDataOutput out) throws IOException {
        out.writeUTF(this.name);
        out.writeUTF(this.managerPrefix);
        out.writeUTF(this.uriString);
        out.writeInt(this.backupCount);
        out.writeInt(this.asyncBackupCount);
        out.writeInt(this.inMemoryFormat.ordinal());
        out.writeInt(this.evictionPolicy.ordinal());
        out.writeInt(this.evictionPercentage);
        out.writeInt(this.evictionThresholdPercentage);
        out.writeObject(this.nearCacheConfig);
        out.writeObject(this.keyType);
        out.writeObject(this.valueType);
        out.writeObject(this.cacheLoaderFactory);
        out.writeObject(this.cacheWriterFactory);
        out.writeObject(this.expiryPolicyFactory);
        out.writeBoolean(this.isReadThrough);
        out.writeBoolean(this.isWriteThrough);
        out.writeBoolean(this.isStoreByValue);
        out.writeBoolean(this.isManagementEnabled);
        out.writeBoolean(this.isStatisticsEnabled);
        boolean listNotEmpty = this.listenerConfigurations != null && !this.listenerConfigurations.isEmpty();
        out.writeBoolean(listNotEmpty);
        if (listNotEmpty) {
            out.writeInt(this.listenerConfigurations.size());
            for (CacheEntryListenerConfiguration cc : this.listenerConfigurations) {
                out.writeObject(cc);
            }
        }
    }

    @Override
    public void readData(ObjectDataInput in) throws IOException {
        this.name = in.readUTF();
        this.managerPrefix = in.readUTF();
        this.uriString = in.readUTF();
        this.backupCount = in.readInt();
        this.asyncBackupCount = in.readInt();
        int resultInMemoryFormat = in.readInt();
        this.inMemoryFormat = InMemoryFormat.values()[resultInMemoryFormat];
        int resultEvictionPolicy = in.readInt();
        this.evictionPolicy = EvictionPolicy.values()[resultEvictionPolicy];
        this.evictionPercentage = in.readInt();
        this.evictionThresholdPercentage = in.readInt();
        this.nearCacheConfig = (NearCacheConfig)in.readObject();
        this.keyType = (Class)in.readObject();
        this.valueType = (Class)in.readObject();
        this.cacheLoaderFactory = (Factory)in.readObject();
        this.cacheWriterFactory = (Factory)in.readObject();
        this.expiryPolicyFactory = (Factory)in.readObject();
        this.isReadThrough = in.readBoolean();
        this.isWriteThrough = in.readBoolean();
        this.isStoreByValue = in.readBoolean();
        this.isManagementEnabled = in.readBoolean();
        this.isStatisticsEnabled = in.readBoolean();
        boolean listNotEmpty = in.readBoolean();
        if (listNotEmpty) {
            int size = in.readInt();
            this.listenerConfigurations = this.createConcurrentSet();
            for (int i = 0; i < size; ++i) {
                this.listenerConfigurations.add((CacheEntryListenerConfiguration)in.readObject());
            }
        }
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
        result = 31 * result + (this.managerPrefix != null ? this.managerPrefix.hashCode() : 0);
        result = 31 * result + (this.uriString != null ? this.uriString.hashCode() : 0);
        return result;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CacheConfig that = (CacheConfig)o;
        if (this.managerPrefix != null ? !this.managerPrefix.equals(that.managerPrefix) : that.managerPrefix != null) {
            return false;
        }
        if (this.name != null ? !this.name.equals(that.name) : that.name != null) {
            return false;
        }
        if (this.uriString != null ? !this.uriString.equals(that.uriString) : that.uriString != null) {
            return false;
        }
        return super.equals(o);
    }

    public String toString() {
        return "CacheConfig{name='" + this.name + '\'' + ", managerPrefix='" + this.managerPrefix + '\'' + ", inMemoryFormat=" + (Object)((Object)this.inMemoryFormat) + ", backupCount=" + this.backupCount + '}';
    }
}

