/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.config;

import com.hazelcast.config.MaxSizeConfigReadOnly;

public class MaxSizeConfig {
    public static final int DEFAULT_MAX_SIZE = Integer.MAX_VALUE;
    private MaxSizeConfigReadOnly readOnly;
    private MaxSizePolicy maxSizePolicy = MaxSizePolicy.PER_NODE;
    private int size = Integer.MAX_VALUE;

    public MaxSizeConfig() {
    }

    public MaxSizeConfig(int size, MaxSizePolicy maxSizePolicy) {
        this.setSize(size);
        this.maxSizePolicy = maxSizePolicy;
    }

    public MaxSizeConfig(MaxSizeConfig config) {
        this.size = config.size;
        this.maxSizePolicy = config.maxSizePolicy;
    }

    public MaxSizeConfigReadOnly getAsReadOnly() {
        if (this.readOnly == null) {
            this.readOnly = new MaxSizeConfigReadOnly(this);
        }
        return this.readOnly;
    }

    public int getSize() {
        return this.size;
    }

    public MaxSizeConfig setSize(int size) {
        if (size > 0) {
            this.size = size;
        }
        return this;
    }

    public MaxSizePolicy getMaxSizePolicy() {
        return this.maxSizePolicy;
    }

    public MaxSizeConfig setMaxSizePolicy(MaxSizePolicy maxSizePolicy) {
        this.maxSizePolicy = maxSizePolicy;
        return this;
    }

    public String toString() {
        return "MaxSizeConfig{maxSizePolicy='" + (Object)((Object)this.maxSizePolicy) + '\'' + ", size=" + this.size + '}';
    }

    public static enum MaxSizePolicy {
        PER_NODE,
        PER_PARTITION,
        USED_HEAP_PERCENTAGE,
        USED_HEAP_SIZE,
        FREE_HEAP_PERCENTAGE,
        FREE_HEAP_SIZE;

    }
}

