/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.instance;

import com.hazelcast.client.impl.ClientServiceProxy;
import com.hazelcast.concurrent.lock.LockProxy;
import com.hazelcast.config.Config;
import com.hazelcast.core.ClientService;
import com.hazelcast.core.Cluster;
import com.hazelcast.core.DistributedObject;
import com.hazelcast.core.DistributedObjectListener;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.HazelcastInstanceAware;
import com.hazelcast.core.IAtomicLong;
import com.hazelcast.core.IAtomicReference;
import com.hazelcast.core.ICountDownLatch;
import com.hazelcast.core.IExecutorService;
import com.hazelcast.core.IList;
import com.hazelcast.core.ILock;
import com.hazelcast.core.IMap;
import com.hazelcast.core.IQueue;
import com.hazelcast.core.ISemaphore;
import com.hazelcast.core.ISet;
import com.hazelcast.core.ITopic;
import com.hazelcast.core.IdGenerator;
import com.hazelcast.core.LifecycleEvent;
import com.hazelcast.core.ManagedContext;
import com.hazelcast.core.Member;
import com.hazelcast.core.MultiMap;
import com.hazelcast.core.PartitionService;
import com.hazelcast.core.ReplicatedMap;
import com.hazelcast.instance.HazelcastManagedContext;
import com.hazelcast.instance.LifecycleServiceImpl;
import com.hazelcast.instance.Node;
import com.hazelcast.instance.NodeContext;
import com.hazelcast.jmx.ManagementService;
import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.LoggingService;
import com.hazelcast.management.ThreadMonitoringService;
import com.hazelcast.mapreduce.JobTracker;
import com.hazelcast.nio.serialization.SerializationService;
import com.hazelcast.spi.ProxyService;
import com.hazelcast.spi.annotation.PrivateApi;
import com.hazelcast.transaction.TransactionContext;
import com.hazelcast.transaction.TransactionException;
import com.hazelcast.transaction.TransactionManagerService;
import com.hazelcast.transaction.TransactionOptions;
import com.hazelcast.transaction.TransactionalTask;
import com.hazelcast.util.EmptyStatement;
import com.hazelcast.util.ExceptionUtil;
import com.hazelcast.util.HealthMonitor;
import com.hazelcast.util.HealthMonitorLevel;
import java.util.Collection;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

@PrivateApi
public final class HazelcastInstanceImpl
implements HazelcastInstance {
    public final Node node;
    final ILogger logger;
    final String name;
    final ManagementService managementService;
    final LifecycleServiceImpl lifecycleService;
    final ManagedContext managedContext;
    final ThreadMonitoringService threadMonitoringService;
    final ThreadGroup threadGroup;
    final ConcurrentMap<String, Object> userContext = new ConcurrentHashMap<String, Object>();

    HazelcastInstanceImpl(String name, Config config, NodeContext nodeContext) throws Exception {
        this.name = name;
        this.threadGroup = new ThreadGroup(name);
        this.threadMonitoringService = new ThreadMonitoringService(this.threadGroup);
        this.lifecycleService = new LifecycleServiceImpl(this);
        ManagedContext configuredManagedContext = config.getManagedContext();
        this.managedContext = new HazelcastManagedContext(this, configuredManagedContext);
        this.userContext.putAll(config.getUserContext());
        this.node = new Node(this, config, nodeContext);
        try {
            this.logger = this.node.getLogger(this.getClass().getName());
            this.lifecycleService.fireLifecycleEvent(LifecycleEvent.LifecycleState.STARTING);
            this.node.start();
            if (!this.node.isActive()) {
                throw new IllegalStateException("Node failed to start!");
            }
            this.managementService = new ManagementService(this);
            this.initManagedContext(configuredManagedContext);
            this.initHealthMonitor();
        }
        catch (Throwable e) {
            try {
                this.node.shutdown(true);
            }
            catch (Throwable ignored) {
                EmptyStatement.ignore(ignored);
            }
            throw ExceptionUtil.rethrow(e);
        }
    }

    private void initManagedContext(ManagedContext configuredManagedContext) {
        if (configuredManagedContext != null && configuredManagedContext instanceof HazelcastInstanceAware) {
            ((HazelcastInstanceAware)((Object)configuredManagedContext)).setHazelcastInstance(this);
        }
    }

    private void initHealthMonitor() {
        String healthMonitorLevelString = this.node.getGroupProperties().HEALTH_MONITORING_LEVEL.getString();
        HealthMonitorLevel healthLevel = HealthMonitorLevel.valueOf(healthMonitorLevelString);
        if (healthLevel != HealthMonitorLevel.OFF) {
            this.logger.finest("Starting health monitor");
            int delaySeconds = this.node.getGroupProperties().HEALTH_MONITORING_DELAY_SECONDS.getInteger();
            new HealthMonitor(this, healthLevel, delaySeconds).start();
        }
    }

    public ManagementService getManagementService() {
        return this.managementService;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public <K, V> IMap<K, V> getMap(String name) {
        if (name == null) {
            throw new NullPointerException("Retrieving a map instance with a null name is not allowed!");
        }
        return (IMap)this.getDistributedObject("hz:impl:mapService", name);
    }

    @Override
    public <E> IQueue<E> getQueue(String name) {
        if (name == null) {
            throw new NullPointerException("Retrieving a queue instance with a null name is not allowed!");
        }
        return (IQueue)this.getDistributedObject("hz:impl:queueService", name);
    }

    @Override
    public <E> ITopic<E> getTopic(String name) {
        if (name == null) {
            throw new NullPointerException("Retrieving a topic instance with a null name is not allowed!");
        }
        return (ITopic)this.getDistributedObject("hz:impl:topicService", name);
    }

    @Override
    public <E> ISet<E> getSet(String name) {
        if (name == null) {
            throw new NullPointerException("Retrieving a set instance with a null name is not allowed!");
        }
        return (ISet)this.getDistributedObject("hz:impl:setService", name);
    }

    @Override
    public <E> IList<E> getList(String name) {
        if (name == null) {
            throw new NullPointerException("Retrieving a list instance with a null name is not allowed!");
        }
        return (IList)this.getDistributedObject("hz:impl:listService", name);
    }

    @Override
    public <K, V> MultiMap<K, V> getMultiMap(String name) {
        if (name == null) {
            throw new NullPointerException("Retrieving a multi-map instance with a null name is not allowed!");
        }
        return (MultiMap)this.getDistributedObject("hz:impl:multiMapService", name);
    }

    @Override
    public JobTracker getJobTracker(String name) {
        if (name == null) {
            throw new NullPointerException("Retrieving a job tracker instance with a null name is not allowed!");
        }
        return (JobTracker)this.getDistributedObject("hz:impl:mapReduceService", name);
    }

    @Override
    @Deprecated
    public ILock getLock(Object key) {
        if (key == null) {
            throw new NullPointerException("Retrieving a lock instance with a null key is not allowed!");
        }
        String name = LockProxy.convertToStringKey(key, this.node.getSerializationService());
        return this.getLock(name);
    }

    @Override
    public ILock getLock(String key) {
        if (key == null) {
            throw new NullPointerException("Retrieving a lock instance with a null key is not allowed!");
        }
        return (ILock)this.getDistributedObject("hz:impl:lockService", key);
    }

    @Override
    public <T> T executeTransaction(TransactionalTask<T> task) throws TransactionException {
        return this.executeTransaction(TransactionOptions.getDefault(), task);
    }

    @Override
    public <T> T executeTransaction(TransactionOptions options, TransactionalTask<T> task) throws TransactionException {
        TransactionManagerService transactionManagerService = this.node.nodeEngine.getTransactionManagerService();
        return transactionManagerService.executeTransaction(options, task);
    }

    @Override
    public TransactionContext newTransactionContext() {
        return this.newTransactionContext(TransactionOptions.getDefault());
    }

    @Override
    public TransactionContext newTransactionContext(TransactionOptions options) {
        TransactionManagerService transactionManagerService = this.node.nodeEngine.getTransactionManagerService();
        return transactionManagerService.newTransactionContext(options);
    }

    @Override
    public IExecutorService getExecutorService(String name) {
        if (name == null) {
            throw new NullPointerException("Retrieving an executor instance with a null name is not allowed!");
        }
        return (IExecutorService)this.getDistributedObject("hz:impl:executorService", name);
    }

    @Override
    public IdGenerator getIdGenerator(String name) {
        if (name == null) {
            throw new NullPointerException("Retrieving an id-generator instance with a null name is not allowed!");
        }
        return (IdGenerator)this.getDistributedObject("hz:impl:idGeneratorService", name);
    }

    @Override
    public IAtomicLong getAtomicLong(String name) {
        if (name == null) {
            throw new NullPointerException("Retrieving an atomic-long instance with a null name is not allowed!");
        }
        return (IAtomicLong)this.getDistributedObject("hz:impl:atomicLongService", name);
    }

    @Override
    public <E> IAtomicReference<E> getAtomicReference(String name) {
        if (name == null) {
            throw new NullPointerException("Retrieving an atomic-reference instance with a null name is not allowed!");
        }
        return (IAtomicReference)this.getDistributedObject("hz:impl:atomicReferenceService", name);
    }

    @Override
    public ICountDownLatch getCountDownLatch(String name) {
        if (name == null) {
            throw new NullPointerException("Retrieving a countdown-latch instance with a null name is not allowed!");
        }
        return (ICountDownLatch)this.getDistributedObject("hz:impl:countDownLatchService", name);
    }

    @Override
    public ISemaphore getSemaphore(String name) {
        if (name == null) {
            throw new NullPointerException("Retrieving a semaphore instance with a null name is not allowed!");
        }
        return (ISemaphore)this.getDistributedObject("hz:impl:semaphoreService", name);
    }

    @Override
    public <K, V> ReplicatedMap<K, V> getReplicatedMap(String name) {
        if (name == null) {
            throw new NullPointerException("Retrieving a replicated map instance with a null name is not allowed!");
        }
        return (ReplicatedMap)this.getDistributedObject("hz:impl:replicatedMapService", name);
    }

    @Override
    public Cluster getCluster() {
        return this.node.clusterService.getClusterProxy();
    }

    @Override
    public Member getLocalEndpoint() {
        return this.node.clusterService.getLocalMember();
    }

    @Override
    public Collection<DistributedObject> getDistributedObjects() {
        ProxyService proxyService = this.node.nodeEngine.getProxyService();
        return proxyService.getAllDistributedObjects();
    }

    @Override
    public Config getConfig() {
        return this.node.getConfig();
    }

    @Override
    public ConcurrentMap<String, Object> getUserContext() {
        return this.userContext;
    }

    @Override
    public PartitionService getPartitionService() {
        return this.node.partitionService.getPartitionServiceProxy();
    }

    @Override
    public ClientService getClientService() {
        return new ClientServiceProxy(this.node);
    }

    @Override
    public LoggingService getLoggingService() {
        return this.node.loggingService;
    }

    @Override
    public LifecycleServiceImpl getLifecycleService() {
        return this.lifecycleService;
    }

    @Override
    public void shutdown() {
        this.getLifecycleService().shutdown();
    }

    @Override
    @Deprecated
    public <T extends DistributedObject> T getDistributedObject(String serviceName, Object id) {
        if (id instanceof String) {
            return (T)this.node.nodeEngine.getProxyService().getDistributedObject(serviceName, (String)id);
        }
        throw new IllegalArgumentException("'id' must be type of String!");
    }

    @Override
    public <T extends DistributedObject> T getDistributedObject(String serviceName, String name) {
        ProxyService proxyService = this.node.nodeEngine.getProxyService();
        return (T)proxyService.getDistributedObject(serviceName, name);
    }

    @Override
    public String addDistributedObjectListener(DistributedObjectListener distributedObjectListener) {
        ProxyService proxyService = this.node.nodeEngine.getProxyService();
        return proxyService.addProxyListener(distributedObjectListener);
    }

    @Override
    public boolean removeDistributedObjectListener(String registrationId) {
        ProxyService proxyService = this.node.nodeEngine.getProxyService();
        return proxyService.removeProxyListener(registrationId);
    }

    public ThreadGroup getThreadGroup() {
        return this.threadGroup;
    }

    public SerializationService getSerializationService() {
        return this.node.getSerializationService();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || !(o instanceof HazelcastInstance)) {
            return false;
        }
        HazelcastInstance that = (HazelcastInstance)o;
        return !(this.name == null ? that.getName() != null : !this.name.equals(that.getName()));
    }

    public int hashCode() {
        return this.name != null ? this.name.hashCode() : 0;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("HazelcastInstance");
        sb.append("{name='").append(this.name).append('\'');
        sb.append(", node=").append(this.node.getThisAddress());
        sb.append('}');
        return sb.toString();
    }
}

