/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.impl;

import com.hazelcast.logging.ILogger;
import com.hazelcast.map.impl.MapContainer;
import com.hazelcast.map.impl.MapEntrySet;
import com.hazelcast.map.impl.MapServiceContext;
import com.hazelcast.map.impl.RecordStore;
import com.hazelcast.map.impl.RecordStoreLoader;
import com.hazelcast.map.impl.mapstore.MapDataStore;
import com.hazelcast.map.impl.operation.PutAllOperation;
import com.hazelcast.map.impl.operation.PutFromLoadAllOperation;
import com.hazelcast.map.impl.record.Record;
import com.hazelcast.nio.Address;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.spi.Callback;
import com.hazelcast.spi.ExecutionService;
import com.hazelcast.spi.NodeEngine;
import com.hazelcast.spi.Operation;
import com.hazelcast.spi.OperationAccessor;
import com.hazelcast.spi.OperationService;
import com.hazelcast.spi.ResponseHandler;
import com.hazelcast.util.Clock;
import com.hazelcast.util.ExceptionUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;

class BasicRecordStoreLoader
implements RecordStoreLoader {
    private final AtomicBoolean loaded;
    private final ILogger logger;
    private final String name;
    private final MapServiceContext mapServiceContext;
    private final MapDataStore mapDataStore;
    private final RecordStore recordStore;
    private final int partitionId;
    private volatile Throwable throwable;

    public BasicRecordStoreLoader(RecordStore recordStore) {
        this.recordStore = recordStore;
        MapContainer mapContainer = recordStore.getMapContainer();
        this.name = mapContainer.getName();
        this.mapServiceContext = mapContainer.getMapServiceContext();
        this.partitionId = recordStore.getPartitionId();
        this.mapDataStore = recordStore.getMapDataStore();
        this.logger = this.mapServiceContext.getNodeEngine().getLogger(this.getClass());
        this.loaded = new AtomicBoolean(false);
    }

    @Override
    public boolean isLoaded() {
        return this.loaded.get();
    }

    @Override
    public void setLoaded(boolean loaded) {
        this.loaded.set(loaded);
    }

    @Override
    public void loadKeys(List<Data> keys, boolean replaceExistingValues) {
        this.setLoaded(false);
        NodeEngine nodeEngine = this.mapServiceContext.getNodeEngine();
        ExecutionService executionService = nodeEngine.getExecutionService();
        executionService.submit("hz:map-loadAllKeys", new LoadAllKeysTask(keys, replaceExistingValues));
    }

    @Override
    public void loadAllKeys() {
        if (this.isLoaded()) {
            return;
        }
        if (!this.isOwner()) {
            this.setLoaded(true);
            return;
        }
        Map<Data, Object> loadedKeys = this.recordStore.getMapContainer().getInitialKeys();
        if (loadedKeys == null || loadedKeys.isEmpty()) {
            this.setLoaded(true);
            return;
        }
        this.doChunkedLoad(loadedKeys, this.mapServiceContext.getNodeEngine());
    }

    @Override
    public Throwable getExceptionOrNull() {
        return this.throwable;
    }

    private boolean isOwner() {
        NodeEngine nodeEngine = this.mapServiceContext.getNodeEngine();
        Address partitionOwner = nodeEngine.getPartitionService().getPartitionOwner(this.partitionId);
        return nodeEngine.getThisAddress().equals(partitionOwner);
    }

    private void loadKeysInternal(List<Data> keys, boolean replaceExistingValues) {
        if (!replaceExistingValues) {
            this.removeExistingKeys(keys);
        }
        this.removeUnloadableKeys(keys);
        if (keys.isEmpty()) {
            this.loaded.set(true);
            return;
        }
        this.doBatchLoad(keys);
    }

    private void doBatchLoad(List<Data> keys) {
        Queue<List<Data>> batchChunks = this.createBatchChunks(keys);
        int size = batchChunks.size();
        AtomicInteger finishedBatchCounter = new AtomicInteger(size);
        while (!batchChunks.isEmpty()) {
            List<Data> chunk = batchChunks.poll();
            List<Data> keyValueSequence = this.loadAndGet(chunk);
            if (keyValueSequence.isEmpty()) {
                if (finishedBatchCounter.decrementAndGet() != 0) continue;
                this.loaded.set(true);
                continue;
            }
            this.sendOperation(keyValueSequence, finishedBatchCounter);
        }
    }

    private Queue<List<Data>> createBatchChunks(List<Data> keys) {
        List<Data> tmpKeys;
        LinkedList<List<Data>> chunks = new LinkedList<List<Data>>();
        int loadBatchSize = this.getLoadBatchSize();
        int page = 0;
        while ((tmpKeys = this.getBatchChunk(keys, loadBatchSize, page++)) != null) {
            chunks.add(tmpKeys);
        }
        return chunks;
    }

    private List<Data> loadAndGet(List<Data> keys) {
        Map entries = Collections.emptyMap();
        try {
            entries = this.mapDataStore.loadAll(keys);
        }
        catch (Throwable t) {
            this.logger.warning("Could not load keys from map store", t);
        }
        return this.getKeyValueSequence(entries);
    }

    private List<Data> getKeyValueSequence(Map<Object, Object> entries) {
        if (entries == null || entries.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<Data> keyValueSequence = new ArrayList<Data>(entries.size());
        for (Map.Entry<Object, Object> entry : entries.entrySet()) {
            Object key = entry.getKey();
            Object value = entry.getValue();
            Data dataKey = this.mapServiceContext.toData(key);
            Data dataValue = this.mapServiceContext.toData(value);
            keyValueSequence.add(dataKey);
            keyValueSequence.add(dataValue);
        }
        return keyValueSequence;
    }

    private List<Data> getBatchChunk(List<Data> list, int batchSize, int chunkNumber) {
        if (list == null || list.isEmpty()) {
            return null;
        }
        int start = chunkNumber * batchSize;
        int end = Math.min(start + batchSize, list.size());
        if (start >= end) {
            return null;
        }
        return list.subList(start, end);
    }

    private void sendOperation(List<Data> keyValueSequence, AtomicInteger finishedBatchCounter) {
        OperationService operationService = this.mapServiceContext.getNodeEngine().getOperationService();
        Operation operation = this.createOperation(keyValueSequence, finishedBatchCounter);
        operationService.executeOperation(operation);
    }

    private Operation createOperation(List<Data> keyValueSequence, final AtomicInteger finishedBatchCounter) {
        NodeEngine nodeEngine = this.mapServiceContext.getNodeEngine();
        PutFromLoadAllOperation operation = new PutFromLoadAllOperation(this.name, keyValueSequence);
        operation.setNodeEngine(nodeEngine);
        operation.setResponseHandler(new ResponseHandler(){

            @Override
            public void sendResponse(Object obj) {
                if (finishedBatchCounter.decrementAndGet() == 0) {
                    BasicRecordStoreLoader.this.loaded.set(true);
                }
            }

            @Override
            public boolean isLocal() {
                return true;
            }
        });
        operation.setPartitionId(this.partitionId);
        OperationAccessor.setCallerAddress(operation, nodeEngine.getThisAddress());
        operation.setCallerUuid(nodeEngine.getLocalMember().getUuid());
        operation.setServiceName("hz:impl:mapService");
        return operation;
    }

    private void removeExistingKeys(Collection<Data> keys) {
        if (keys == null || keys.isEmpty()) {
            return;
        }
        Map<Data, Record> records = this.recordStore.getRecordMap();
        Iterator<Data> iterator = keys.iterator();
        while (iterator.hasNext()) {
            Data nextKey = iterator.next();
            if (!records.containsKey(nextKey)) continue;
            iterator.remove();
        }
    }

    private void removeUnloadableKeys(Collection<Data> keys) {
        if (keys == null || keys.isEmpty()) {
            return;
        }
        long now = this.getNow();
        Iterator<Data> iterator = keys.iterator();
        while (iterator.hasNext()) {
            Data key;
            Record record = this.recordStore.getRecord(key = iterator.next());
            long lastUpdateTime = record == null ? 0L : record.getLastUpdateTime();
            if (this.mapDataStore.loadable(key, lastUpdateTime, now)) continue;
            iterator.remove();
        }
    }

    private int getLoadBatchSize() {
        return this.mapServiceContext.getNodeEngine().getGroupProperties().MAP_LOAD_CHUNK_SIZE.getInteger();
    }

    private long getNow() {
        return Clock.currentTimeMillis();
    }

    private void doChunkedLoad(Map<Data, Object> loadedKeys, NodeEngine nodeEngine) {
        int mapLoadChunkSize = this.getLoadBatchSize();
        LinkedList chunks = new LinkedList();
        HashMap<Data, Object> partitionKeys = new HashMap<Data, Object>();
        int partitionId = this.partitionId;
        Iterator<Map.Entry<Data, Object>> iterator = loadedKeys.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<Data, Object> entry = iterator.next();
            Data data = entry.getKey();
            if (partitionId != nodeEngine.getPartitionService().getPartitionId(data)) continue;
            partitionKeys.put(data, entry.getValue());
            if (partitionKeys.size() >= mapLoadChunkSize) {
                chunks.add(partitionKeys);
                partitionKeys = new HashMap();
            }
            iterator.remove();
        }
        if (!partitionKeys.isEmpty()) {
            chunks.add(partitionKeys);
        }
        if (chunks.isEmpty()) {
            this.setLoaded(true);
            return;
        }
        try {
            Map chunkedKeys;
            this.throwable = null;
            AtomicInteger checkIfMapLoaded = new AtomicInteger(chunks.size());
            ExecutionService executionService = nodeEngine.getExecutionService();
            while ((chunkedKeys = (Map)chunks.poll()) != null) {
                Callback<Throwable> callback = this.createCallbackForThrowable();
                MapLoadAllTask task = new MapLoadAllTask(chunkedKeys, checkIfMapLoaded, callback);
                executionService.submit("hz:map-load", task);
            }
        }
        catch (Throwable t) {
            throw ExceptionUtil.rethrow(t);
        }
    }

    private Callback<Throwable> createCallbackForThrowable() {
        return new Callback<Throwable>(){

            @Override
            public void notify(Throwable throwable) {
                BasicRecordStoreLoader.this.throwable = throwable;
            }
        };
    }

    private final class MapLoadAllTask
    implements Runnable {
        private final Map<Data, Object> keys;
        private final AtomicInteger checkIfMapLoaded;
        private final Callback callback;

        private MapLoadAllTask(Map<Data, Object> keys, AtomicInteger checkIfMapLoaded, Callback callback) {
            this.keys = keys;
            this.checkIfMapLoaded = checkIfMapLoaded;
            this.callback = callback;
        }

        @Override
        public void run() {
            NodeEngine nodeEngine = BasicRecordStoreLoader.this.mapServiceContext.getNodeEngine();
            try {
                Map values = BasicRecordStoreLoader.this.mapDataStore.loadAll(this.keys.values());
                if (values == null || values.isEmpty()) {
                    this.decrementCounterAndMarkAsLoaded();
                    return;
                }
                MapEntrySet entrySet = new MapEntrySet();
                for (Data dataKey : this.keys.keySet()) {
                    Object key = this.keys.get(dataKey);
                    Object value = values.get(key);
                    if (value == null) continue;
                    Data dataValue = BasicRecordStoreLoader.this.mapServiceContext.toData(value);
                    entrySet.add(dataKey, dataValue);
                }
                PutAllOperation operation = new PutAllOperation(BasicRecordStoreLoader.this.name, entrySet, true);
                OperationService operationService = nodeEngine.getOperationService();
                operationService.createInvocationBuilder("hz:impl:mapService", (Operation)operation, BasicRecordStoreLoader.this.partitionId).setCallback(new Callback<Object>(){

                    @Override
                    public void notify(Object obj) {
                        if (obj instanceof Throwable) {
                            return;
                        }
                        MapLoadAllTask.this.decrementCounterAndMarkAsLoaded();
                    }
                }).invoke();
            }
            catch (Throwable t) {
                this.decrementCounterAndMarkAsLoaded();
                BasicRecordStoreLoader.this.logger.warning("Exception while load all task:" + t.toString());
                this.callback.notify(t);
            }
        }

        private void decrementCounterAndMarkAsLoaded() {
            if (this.checkIfMapLoaded.decrementAndGet() == 0) {
                BasicRecordStoreLoader.this.setLoaded(true);
            }
        }
    }

    private final class LoadAllKeysTask
    implements Runnable {
        private final List<Data> keys;
        private final boolean replaceExistingValues;

        private LoadAllKeysTask(List<Data> keys, boolean replaceExistingValues) {
            this.keys = keys;
            this.replaceExistingValues = replaceExistingValues;
        }

        @Override
        public void run() {
            BasicRecordStoreLoader.this.loadKeysInternal(this.keys, this.replaceExistingValues);
        }
    }
}

