/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.impl;

import com.hazelcast.config.MapConfig;
import com.hazelcast.config.MapStoreConfig;
import com.hazelcast.config.MaxSizeConfig;
import com.hazelcast.map.impl.ExpirationTimeSetter;

abstract class MapContainerSupport {
    protected volatile MapConfig mapConfig;
    private final long maxIdleMillis;
    private final long ttlMillisFromConfig;
    private final String name;

    protected MapContainerSupport(String name, MapConfig mapConfig) {
        this.name = name;
        this.mapConfig = mapConfig;
        this.maxIdleMillis = ExpirationTimeSetter.calculateMaxIdleMillis(mapConfig);
        this.ttlMillisFromConfig = ExpirationTimeSetter.calculateTTLMillis(mapConfig);
    }

    public boolean isMapStoreEnabled() {
        MapStoreConfig mapStoreConfig = this.mapConfig.getMapStoreConfig();
        return mapStoreConfig != null && mapStoreConfig.isEnabled();
    }

    public boolean isWriteBehindMapStoreEnabled() {
        MapStoreConfig mapStoreConfig = this.mapConfig.getMapStoreConfig();
        return mapStoreConfig != null && mapStoreConfig.isEnabled() && mapStoreConfig.getWriteDelaySeconds() > 0;
    }

    public int getMaxSizePerNode() {
        MaxSizeConfig maxSizeConfig = this.mapConfig.getMaxSizeConfig();
        int maxSize = -1;
        if (maxSizeConfig.getMaxSizePolicy() == MaxSizeConfig.MaxSizePolicy.PER_NODE) {
            maxSize = maxSizeConfig.getSize();
        }
        return maxSize;
    }

    public MapConfig getMapConfig() {
        return this.mapConfig;
    }

    public void setMapConfig(MapConfig mapConfig) {
        this.mapConfig = mapConfig;
    }

    public long getMaxIdleMillis() {
        return this.maxIdleMillis;
    }

    public long getTtlMillisFromConfig() {
        return this.ttlMillisFromConfig;
    }

    public String getName() {
        return this.name;
    }
}

