/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.impl.operation;

import com.hazelcast.map.impl.MapEntrySet;
import com.hazelcast.map.impl.RecordStore;
import com.hazelcast.map.impl.operation.AbstractMapOperation;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.spi.PartitionAwareOperation;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;

public class GetAllOperation
extends AbstractMapOperation
implements PartitionAwareOperation {
    Set<Data> keys = new HashSet<Data>();
    MapEntrySet entrySet;

    public GetAllOperation(String name, Set<Data> keys) {
        super(name);
        this.keys = keys;
    }

    public GetAllOperation() {
    }

    @Override
    public void run() {
        int partitionId = this.getPartitionId();
        RecordStore recordStore = this.mapService.getMapServiceContext().getRecordStore(partitionId, this.name);
        HashSet<Data> partitionKeySet = new HashSet<Data>();
        for (Data key : this.keys) {
            if (partitionId != this.getNodeEngine().getPartitionService().getPartitionId(key)) continue;
            partitionKeySet.add(key);
        }
        this.entrySet = recordStore.getAll(partitionKeySet);
    }

    @Override
    public Object getResponse() {
        return this.entrySet;
    }

    public String toString() {
        return "GetAllOperation{}";
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        super.writeInternal(out);
        if (this.keys == null) {
            out.writeInt(-1);
        } else {
            out.writeInt(this.keys.size());
            for (Data key : this.keys) {
                out.writeData(key);
            }
        }
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        super.readInternal(in);
        int size = in.readInt();
        if (size > -1) {
            for (int i = 0; i < size; ++i) {
                Data data = in.readData();
                this.keys.add(data);
            }
        }
    }
}

