/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.impl.operation;

import com.hazelcast.map.impl.MapContainer;
import com.hazelcast.map.impl.MapService;
import com.hazelcast.map.impl.PartitionContainer;
import com.hazelcast.map.impl.RecordStore;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.spi.Operation;
import com.hazelcast.spi.PartitionAwareOperation;
import java.io.IOException;

public abstract class KeyBasedMapOperation
extends Operation
implements PartitionAwareOperation {
    protected String name;
    protected Data dataKey;
    protected long threadId;
    protected Data dataValue;
    protected long ttl = -1L;
    protected transient MapService mapService;
    protected transient MapContainer mapContainer;
    protected transient PartitionContainer partitionContainer;
    protected transient RecordStore recordStore;

    public KeyBasedMapOperation() {
    }

    public KeyBasedMapOperation(String name, Data dataKey) {
        this.dataKey = dataKey;
        this.name = name;
    }

    protected KeyBasedMapOperation(String name, Data dataKey, Data dataValue) {
        this.name = name;
        this.dataKey = dataKey;
        this.dataValue = dataValue;
    }

    protected KeyBasedMapOperation(String name, Data dataKey, long ttl) {
        this.name = name;
        this.dataKey = dataKey;
        this.ttl = ttl;
    }

    protected KeyBasedMapOperation(String name, Data dataKey, Data dataValue, long ttl) {
        this.name = name;
        this.dataKey = dataKey;
        this.dataValue = dataValue;
        this.ttl = ttl;
    }

    public final String getName() {
        return this.name;
    }

    public final Data getKey() {
        return this.dataKey;
    }

    public final long getThreadId() {
        return this.threadId;
    }

    public final void setThreadId(long threadId) {
        this.threadId = threadId;
    }

    public final Data getValue() {
        return this.dataValue;
    }

    public final long getTtl() {
        return this.ttl;
    }

    @Override
    public final void beforeRun() throws Exception {
        this.mapService = (MapService)this.getService();
        this.mapContainer = this.mapService.getMapServiceContext().getMapContainer(this.name);
        this.partitionContainer = this.mapService.getMapServiceContext().getPartitionContainer(this.getPartitionId());
        this.recordStore = this.partitionContainer.getRecordStore(this.name);
        this.innerBeforeRun();
    }

    public void innerBeforeRun() {
    }

    @Override
    public void afterRun() throws Exception {
    }

    @Override
    public boolean returnsResponse() {
        return true;
    }

    protected final void invalidateNearCaches() {
        if (this.mapContainer.isNearCacheEnabled() && this.mapContainer.getMapConfig().getNearCacheConfig().isInvalidateOnChange()) {
            this.mapService.getMapServiceContext().getNearCacheProvider().invalidateAllNearCaches(this.name, this.dataKey);
        }
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        out.writeUTF(this.name);
        out.writeData(this.dataKey);
        out.writeLong(this.threadId);
        out.writeData(this.dataValue);
        out.writeLong(this.ttl);
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        this.name = in.readUTF();
        this.dataKey = in.readData();
        this.threadId = in.readLong();
        this.dataValue = in.readData();
        this.ttl = in.readLong();
    }
}

