/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.impl.operation;

import com.hazelcast.map.EntryBackupProcessor;
import com.hazelcast.map.impl.operation.AbstractMultipleEntryOperation;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.spi.BackupOperation;
import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class MultipleEntryBackupOperation
extends AbstractMultipleEntryOperation
implements BackupOperation {
    private Set<Data> keys;

    public MultipleEntryBackupOperation() {
    }

    public MultipleEntryBackupOperation(String name, Set<Data> keys, EntryBackupProcessor backupProcessor) {
        super(name, backupProcessor);
        this.keys = keys;
    }

    @Override
    public void run() throws Exception {
        long now = this.getNow();
        Set<Data> keys = this.keys;
        for (Data dataKey : keys) {
            if (this.keyNotOwnedByThisPartition(dataKey)) continue;
            Object oldValue = this.getValueFor(dataKey, now);
            Object key = this.toObject(dataKey);
            Object value = this.toObject(oldValue);
            Map.Entry entry = this.createMapEntry(key, value);
            this.processBackup(entry);
            if (this.noOp(entry, oldValue) || this.entryRemovedBackup(entry, dataKey)) continue;
            this.entryAddedOrUpdatedBackup(entry, dataKey);
        }
    }

    @Override
    public boolean returnsResponse() {
        return true;
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        super.readInternal(in);
        this.backupProcessor = (EntryBackupProcessor)in.readObject();
        int size = in.readInt();
        this.keys = new HashSet<Data>(size);
        for (int i = 0; i < size; ++i) {
            Data key = in.readData();
            this.keys.add(key);
        }
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        super.writeInternal(out);
        out.writeObject(this.backupProcessor);
        out.writeInt(this.keys.size());
        for (Data key : this.keys) {
            out.writeData(key);
        }
    }

    @Override
    public Object getResponse() {
        return true;
    }

    public String toString() {
        return "MultipleEntryBackupOperation{}";
    }
}

